/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry.reactor;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.retry.reactor.BackoffDelay;
import com.couchbase.client.core.retry.reactor.IterationContext;
import java.time.Duration;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

public interface Backoff
extends Function<IterationContext<?>, BackoffDelay> {
    public static final Backoff ZERO_BACKOFF = new Backoff(){

        @Override
        public BackoffDelay apply(IterationContext<?> context) {
            return BackoffDelay.ZERO;
        }

        public String toString() {
            return "Backoff{ZERO}";
        }
    };

    public static Backoff zero() {
        return ZERO_BACKOFF;
    }

    public static Backoff fixed(final Duration backoffInterval) {
        return new Backoff(){

            @Override
            public BackoffDelay apply(IterationContext<?> context) {
                return new BackoffDelay(backoffInterval);
            }

            public String toString() {
                return "Backoff{fixed=" + backoffInterval.toMillis() + "ms}";
            }
        };
    }

    public static Backoff exponential(final Duration firstBackoff, final @Nullable Duration maxBackoff, final int factor, boolean basedOnPreviousValue) {
        Duration maxBackoffInterval;
        if (firstBackoff == null || firstBackoff.isNegative() || firstBackoff.isZero()) {
            throw InvalidArgumentException.fromMessage("firstBackoff must be > 0");
        }
        Duration duration = maxBackoffInterval = maxBackoff != null ? maxBackoff : Duration.ofSeconds(Long.MAX_VALUE);
        if (maxBackoffInterval.compareTo(firstBackoff) < 0) {
            throw InvalidArgumentException.fromMessage("maxBackoff must be >= firstBackoff");
        }
        if (!basedOnPreviousValue) {
            return new Backoff(){

                @Override
                public BackoffDelay apply(IterationContext<?> context) {
                    Duration nextBackoff;
                    if (context.backoff() != null && context.backoff().compareTo(maxBackoffInterval) >= 0) {
                        nextBackoff = maxBackoffInterval;
                    } else {
                        try {
                            nextBackoff = firstBackoff.multipliedBy((long)Math.pow(factor, context.iteration() - 1L));
                        }
                        catch (ArithmeticException e) {
                            nextBackoff = maxBackoffInterval;
                        }
                    }
                    return new BackoffDelay(firstBackoff, maxBackoffInterval, nextBackoff);
                }

                public String toString() {
                    return String.format("Backoff{exponential,min=%sms,max=%s,factor=%s,basedOnPreviousValue=false}", firstBackoff.toMillis(), maxBackoff == null ? "NONE" : maxBackoff.toMillis() + "ms", factor);
                }
            };
        }
        return new Backoff(){

            @Override
            public BackoffDelay apply(IterationContext<?> context) {
                Duration nextBackoff;
                Duration prevBackoff;
                Duration duration = prevBackoff = context.backoff() == null ? Duration.ZERO : context.backoff();
                if (prevBackoff.compareTo(maxBackoffInterval) >= 0) {
                    nextBackoff = maxBackoffInterval;
                } else {
                    try {
                        nextBackoff = prevBackoff.multipliedBy(factor);
                    }
                    catch (ArithmeticException e) {
                        nextBackoff = maxBackoffInterval;
                    }
                }
                nextBackoff = nextBackoff.compareTo(firstBackoff) < 0 ? firstBackoff : nextBackoff;
                return new BackoffDelay(firstBackoff, maxBackoff, nextBackoff);
            }

            public String toString() {
                return String.format("Backoff{exponential,min=%sms,max=%s,factor=%s,basedOnPreviousValue=true}", firstBackoff.toMillis(), maxBackoff == null ? "NONE" : maxBackoff.toMillis() + "ms", factor);
            }
        };
    }
}

