/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.config;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import java.time.Duration;
import java.util.Optional;

public class BucketConfigRefreshFailedEvent
extends AbstractEvent {
    private final RefresherType type;
    private final Reason reason;
    private final Optional<Object> cause;

    public BucketConfigRefreshFailedEvent(Context context, RefresherType type, Reason reason, Optional<Object> cause) {
        super(reason.severity(), Event.Category.CONFIG, Duration.ZERO, context);
        this.type = type;
        this.reason = reason;
        this.cause = cause;
    }

    @Override
    public String description() {
        return "Reason: " + (Object)((Object)this.reason) + ", Type: " + (Object)((Object)this.type) + ", Cause: " + this.cause.map(Object::toString).orElse("none");
    }

    public static enum Reason {
        NO_BUCKET_FOUND(Event.Severity.DEBUG),
        INDIVIDUAL_REQUEST_FAILED(Event.Severity.DEBUG),
        STREAM_CLOSED(Event.Severity.DEBUG),
        STREAM_FAILED(Event.Severity.WARN);

        private final Event.Severity severity;

        private Reason(Event.Severity severity) {
            this.severity = severity;
        }

        Event.Severity severity() {
            return this.severity;
        }
    }

    public static enum RefresherType {
        KV,
        MANAGER;

    }
}

