/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponseStatus;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.GenericHttpRequestErrorContext;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.CbThrowables;

@Stability.Internal
public class HttpStatusCodeException
extends CouchbaseException {
    private final int httpStatusCode;
    private final ResponseStatus couchbaseResponseStatus;
    private final String content;

    public HttpStatusCodeException(HttpResponseStatus status, String content, Request<?> request, ErrorContext errorContext) {
        super("Unexpected HTTP status " + status, errorContext == null ? new GenericHttpRequestErrorContext(request, status.code()) : errorContext);
        this.httpStatusCode = status.code();
        this.couchbaseResponseStatus = HttpProtocol.decodeStatus(status);
        this.content = CbStrings.nullToEmpty(content);
    }

    public ResponseStatus responseStatus() {
        return this.couchbaseResponseStatus;
    }

    public int httpStatusCode() {
        return this.httpStatusCode;
    }

    public String content() {
        return this.content;
    }

    public static String httpResponseBody(Throwable t) {
        return CbThrowables.findCause(t, HttpStatusCodeException.class).map(HttpStatusCodeException::content).orElse("");
    }

    public static ResponseStatus couchbaseResponseStatus(Throwable t) {
        return CbThrowables.findCause(t, HttpStatusCodeException.class).map(HttpStatusCodeException::responseStatus).orElse(ResponseStatus.UNKNOWN);
    }
}

