/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.annotation.Stability;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;

@Stability.Internal
public class ProtostellarStatsCollector {
    private int channelsCreated = 0;
    private int subChannelsCreated = 0;
    private AtomicInteger concurrentlyOutgoingMessages = new AtomicInteger();
    private Set<Integer> concurrentlyOutgoingMessagesSeen = new ConcurrentSkipListSet<Integer>();
    private AtomicInteger concurrentlyIncomingMessages = new AtomicInteger();
    private Set<Integer> concurrentlyIncomingMessagesSeen = new ConcurrentSkipListSet<Integer>();
    private Set<Integer> maxThreadCountsSeen = new ConcurrentSkipListSet<Integer>();

    public void channelAdded() {
        ++this.channelsCreated;
    }

    public void subChannelAdded() {
        ++this.subChannelsCreated;
    }

    public int channelsCreated() {
        return this.channelsCreated;
    }

    public int subChannelsCreated() {
        return this.subChannelsCreated;
    }

    public void reset() {
        this.channelsCreated = 0;
        this.subChannelsCreated = 0;
    }

    public void outboundMessageSent() {
        this.concurrentlyOutgoingMessages.decrementAndGet();
    }

    public void outboundMessage() {
        this.concurrentlyOutgoingMessagesSeen.add(this.concurrentlyOutgoingMessages.incrementAndGet());
    }

    public void inboundMessage() {
        this.concurrentlyIncomingMessagesSeen.add(this.concurrentlyIncomingMessages.incrementAndGet());
    }

    public void inboundMessageRead() {
        this.concurrentlyIncomingMessages.decrementAndGet();
    }

    public int inflightOutgoingMessagesMax() {
        return this.concurrentlyOutgoingMessagesSeen.stream().max(Comparator.comparingInt(v -> v)).orElse(0);
    }

    public int inflightIncomingMessagesMax() {
        return this.concurrentlyIncomingMessagesSeen.stream().max(Comparator.comparingInt(v -> v)).orElse(0);
    }

    public void currentMaxThreadCount(int activeThreadCount) {
        this.maxThreadCountsSeen.add(activeThreadCount);
    }

    public int maxThreadCount() {
        return this.maxThreadCountsSeen.stream().max(Comparator.comparingInt(v -> v)).orElse(0);
    }
}

