/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.log;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.core.LogEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Stability.Internal
public class SimpleEventBusLogger {
    private static final Pattern PLACEHOLDER = Pattern.compile(Pattern.quote("{}"));
    private final EventBus eventBus;
    private final String category;

    public SimpleEventBusLogger(EventBus eventBus, String category) {
        this.eventBus = Objects.requireNonNull(eventBus);
        this.category = Objects.requireNonNull(category);
    }

    public void verbose(String message, Object ... args) {
        this.internal(message, Event.Severity.VERBOSE, args);
    }

    public void debug(String message, Object ... args) {
        this.internal(message, Event.Severity.DEBUG, args);
    }

    public void info(String message, Object ... args) {
        this.internal(message, Event.Severity.INFO, args);
    }

    public void warn(String message, Object ... args) {
        this.internal(message, Event.Severity.WARN, args);
    }

    public void error(String message, Object ... args) {
        this.internal(message, Event.Severity.ERROR, args);
    }

    private void internal(String message, Event.Severity level, Object ... args) {
        String s = SimpleEventBusLogger.format(message, args);
        this.eventBus.publish(new LogEvent(level, this.category, s));
    }

    public static String format(String message, Object ... args) {
        Object lastExtraArg;
        if (args.length == 0) {
            return message;
        }
        Iterator<Object> i = Arrays.asList(args).iterator();
        Matcher m = PLACEHOLDER.matcher(message);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String replacement = i.hasNext() ? String.valueOf(i.next()) : "{}";
            m.appendReplacement(result, replacement);
        }
        m.appendTail(result);
        if (i.hasNext() && (lastExtraArg = args[args.length - 1]) instanceof Throwable) {
            result.append("\n").append(SimpleEventBusLogger.stackTraceToString((Throwable)lastExtraArg));
        }
        return result.toString();
    }

    public static String stackTraceToString(Throwable t) {
        StringWriter w = new StringWriter();
        t.printStackTrace(new PrintWriter(w));
        return w.toString();
    }
}

