/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.eventing;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.java.manager.eventing.DeployFunctionOptions;
import com.couchbase.client.java.manager.eventing.DropFunctionOptions;
import com.couchbase.client.java.manager.eventing.EventingFunction;
import com.couchbase.client.java.manager.eventing.EventingStatus;
import com.couchbase.client.java.manager.eventing.FunctionsStatusOptions;
import com.couchbase.client.java.manager.eventing.GetAllFunctionsOptions;
import com.couchbase.client.java.manager.eventing.GetFunctionOptions;
import com.couchbase.client.java.manager.eventing.PauseFunctionOptions;
import com.couchbase.client.java.manager.eventing.ResumeFunctionOptions;
import com.couchbase.client.java.manager.eventing.UndeployFunctionOptions;
import com.couchbase.client.java.manager.eventing.UpsertFunctionOptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Uncommitted
public class ReactiveEventingFunctionManager {
    private final AsyncEventingFunctionManager asyncManager;

    @Stability.Internal
    public ReactiveEventingFunctionManager(AsyncEventingFunctionManager asyncManager) {
        this.asyncManager = asyncManager;
    }

    public Mono<Void> upsertFunction(EventingFunction function) {
        return this.upsertFunction(function, UpsertFunctionOptions.upsertFunctionOptions());
    }

    public Mono<Void> upsertFunction(EventingFunction function, UpsertFunctionOptions options) {
        return Reactor.toMono(() -> this.asyncManager.upsertFunction(function, options));
    }

    public Mono<EventingFunction> getFunction(String name) {
        return this.getFunction(name, GetFunctionOptions.getFunctionOptions());
    }

    public Mono<EventingFunction> getFunction(String name, GetFunctionOptions options) {
        return Reactor.toMono(() -> this.asyncManager.getFunction(name, options));
    }

    public Flux<EventingFunction> getAllFunctions() {
        return this.getAllFunctions(GetAllFunctionsOptions.getAllFunctionsOptions());
    }

    public Flux<EventingFunction> getAllFunctions(GetAllFunctionsOptions options) {
        return Reactor.toMono(() -> this.asyncManager.getAllFunctions(options)).flatMapMany(Flux::fromIterable);
    }

    public Mono<Void> dropFunction(String name) {
        return this.dropFunction(name, DropFunctionOptions.dropFunctionOptions());
    }

    public Mono<Void> dropFunction(String name, DropFunctionOptions options) {
        return Reactor.toMono(() -> this.asyncManager.dropFunction(name, options));
    }

    public Mono<Void> deployFunction(String name) {
        return this.deployFunction(name, DeployFunctionOptions.deployFunctionOptions());
    }

    public Mono<Void> deployFunction(String name, DeployFunctionOptions options) {
        return Reactor.toMono(() -> this.asyncManager.deployFunction(name, options));
    }

    public Mono<Void> undeployFunction(String name) {
        return this.undeployFunction(name, UndeployFunctionOptions.undeployFunctionOptions());
    }

    public Mono<Void> undeployFunction(String name, UndeployFunctionOptions options) {
        return Reactor.toMono(() -> this.asyncManager.undeployFunction(name, options));
    }

    public Mono<Void> pauseFunction(String name) {
        return this.pauseFunction(name, PauseFunctionOptions.pauseFunctionOptions());
    }

    public Mono<Void> pauseFunction(String name, PauseFunctionOptions options) {
        return Reactor.toMono(() -> this.asyncManager.pauseFunction(name, options));
    }

    public Mono<Void> resumeFunction(String name) {
        return this.resumeFunction(name, ResumeFunctionOptions.resumeFunctionOptions());
    }

    public Mono<Void> resumeFunction(String name, ResumeFunctionOptions options) {
        return Reactor.toMono(() -> this.asyncManager.resumeFunction(name, options));
    }

    public Mono<EventingStatus> functionsStatus() {
        return this.functionsStatus(FunctionsStatusOptions.functionsStatusOptions());
    }

    public Mono<EventingStatus> functionsStatus(FunctionsStatusOptions options) {
        return Reactor.toMono(() -> this.asyncManager.functionsStatus(options));
    }
}

