/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.search;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CoreAsyncUtils;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.search.AllowQueryingSearchIndexOptions;
import com.couchbase.client.java.manager.search.AnalyzeDocumentOptions;
import com.couchbase.client.java.manager.search.AsyncScopeSearchIndexManager;
import com.couchbase.client.java.manager.search.DisallowQueryingSearchIndexOptions;
import com.couchbase.client.java.manager.search.DropSearchIndexOptions;
import com.couchbase.client.java.manager.search.FreezePlanSearchIndexOptions;
import com.couchbase.client.java.manager.search.GetAllSearchIndexesOptions;
import com.couchbase.client.java.manager.search.GetIndexedSearchIndexOptions;
import com.couchbase.client.java.manager.search.GetSearchIndexOptions;
import com.couchbase.client.java.manager.search.PauseIngestSearchIndexOptions;
import com.couchbase.client.java.manager.search.ResumeIngestSearchIndexOptions;
import com.couchbase.client.java.manager.search.SearchIndex;
import com.couchbase.client.java.manager.search.UnfreezePlanSearchIndexOptions;
import com.couchbase.client.java.manager.search.UpsertSearchIndexOptions;
import java.util.List;

@Stability.Volatile
public class ScopeSearchIndexManager {
    private final AsyncScopeSearchIndexManager internal;

    public ScopeSearchIndexManager(AsyncScopeSearchIndexManager internal) {
        this.internal = internal;
    }

    public SearchIndex getIndex(String name) {
        return this.getIndex(name, GetSearchIndexOptions.getSearchIndexOptions());
    }

    public SearchIndex getIndex(String name, GetSearchIndexOptions options) {
        return (SearchIndex)CoreAsyncUtils.block(this.internal.getIndex(name, options));
    }

    public List<SearchIndex> getAllIndexes() {
        return this.getAllIndexes(GetAllSearchIndexesOptions.getAllSearchIndexesOptions());
    }

    public List<SearchIndex> getAllIndexes(GetAllSearchIndexesOptions options) {
        return (List)CoreAsyncUtils.block(this.internal.getAllIndexes(options));
    }

    public Long getIndexedDocumentsCount(String name) {
        return this.getIndexedDocumentsCount(name, GetIndexedSearchIndexOptions.getIndexedSearchIndexOptions());
    }

    public Long getIndexedDocumentsCount(String name, GetIndexedSearchIndexOptions options) {
        return (Long)CoreAsyncUtils.block(this.internal.getIndexedDocumentsCount(name, options));
    }

    public void upsertIndex(SearchIndex index) {
        this.upsertIndex(index, UpsertSearchIndexOptions.upsertSearchIndexOptions());
    }

    public void upsertIndex(SearchIndex index, UpsertSearchIndexOptions options) {
        CoreAsyncUtils.block(this.internal.upsertIndex(index, options));
    }

    public void dropIndex(String name) {
        this.dropIndex(name, DropSearchIndexOptions.dropSearchIndexOptions());
    }

    public void dropIndex(String name, DropSearchIndexOptions options) {
        CoreAsyncUtils.block(this.internal.dropIndex(name, options));
    }

    public List<JsonObject> analyzeDocument(String name, JsonObject document) {
        return this.analyzeDocument(name, document, AnalyzeDocumentOptions.analyzeDocumentOptions());
    }

    public List<JsonObject> analyzeDocument(String name, JsonObject document, AnalyzeDocumentOptions options) {
        return (List)CoreAsyncUtils.block(this.internal.analyzeDocument(name, document, options));
    }

    public void pauseIngest(String name) {
        this.pauseIngest(name, PauseIngestSearchIndexOptions.pauseIngestSearchIndexOptions());
    }

    public void pauseIngest(String name, PauseIngestSearchIndexOptions options) {
        CoreAsyncUtils.block(this.internal.pauseIngest(name, options));
    }

    public void resumeIngest(String name) {
        this.resumeIngest(name, ResumeIngestSearchIndexOptions.resumeIngestSearchIndexOptions());
    }

    public void resumeIngest(String name, ResumeIngestSearchIndexOptions options) {
        CoreAsyncUtils.block(this.internal.resumeIngest(name, options));
    }

    public void allowQuerying(String name) {
        this.allowQuerying(name, AllowQueryingSearchIndexOptions.allowQueryingSearchIndexOptions());
    }

    public void allowQuerying(String name, AllowQueryingSearchIndexOptions options) {
        CoreAsyncUtils.block(this.internal.allowQuerying(name, options));
    }

    public void disallowQuerying(String name) {
        this.disallowQuerying(name, DisallowQueryingSearchIndexOptions.disallowQueryingSearchIndexOptions());
    }

    public void disallowQuerying(String name, DisallowQueryingSearchIndexOptions options) {
        this.internal.disallowQuerying(name, options);
    }

    public void freezePlan(String name) {
        this.freezePlan(name, FreezePlanSearchIndexOptions.freezePlanSearchIndexOptions());
    }

    public void freezePlan(String name, FreezePlanSearchIndexOptions options) {
        this.internal.freezePlan(name, options);
    }

    public void unfreezePlan(String name) {
        this.unfreezePlan(name, UnfreezePlanSearchIndexOptions.unfreezePlanSearchIndexOptions());
    }

    public void unfreezePlan(String name, UnfreezePlanSearchIndexOptions options) {
        CoreAsyncUtils.block(this.internal.unfreezePlan(name, options));
    }
}

