/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.error.internal;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.AmbiguousTimeoutException;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.DurabilityAmbiguousException;
import com.couchbase.client.core.error.DurableWriteInProgressException;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.error.TemporaryFailureException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.error.ValueTooLargeException;
import com.couchbase.client.core.error.subdoc.PathExistsException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.core.error.transaction.AttemptExpiredException;
import com.couchbase.client.core.error.transaction.DocumentAlreadyInTransactionException;
import com.couchbase.client.core.error.transaction.TransactionOperationFailedException;
import com.couchbase.client.core.error.transaction.internal.TestFailAmbiguousException;
import com.couchbase.client.core.error.transaction.internal.TestFailHardException;
import com.couchbase.client.core.error.transaction.internal.TestFailTransientException;

@Stability.Internal
public enum ErrorClass {
    TRANSACTION_OPERATION_FAILED,
    FAIL_TRANSIENT,
    FAIL_HARD,
    FAIL_OTHER,
    FAIL_AMBIGUOUS,
    FAIL_DOC_ALREADY_EXISTS,
    FAIL_DOC_NOT_FOUND,
    FAIL_PATH_ALREADY_EXISTS,
    FAIL_PATH_NOT_FOUND,
    FAIL_CAS_MISMATCH,
    FAIL_EXPIRY,
    FAIL_WRITE_WRITE_CONFLICT,
    FAIL_ATR_FULL;


    public static ErrorClass classify(Throwable err) {
        if (err instanceof TransactionOperationFailedException) {
            return TRANSACTION_OPERATION_FAILED;
        }
        if (err instanceof DocumentAlreadyInTransactionException) {
            return FAIL_WRITE_WRITE_CONFLICT;
        }
        if (err instanceof DocumentNotFoundException) {
            return FAIL_DOC_NOT_FOUND;
        }
        if (err instanceof DocumentExistsException) {
            return FAIL_DOC_ALREADY_EXISTS;
        }
        if (err instanceof PathExistsException) {
            return FAIL_PATH_ALREADY_EXISTS;
        }
        if (err instanceof PathNotFoundException) {
            return FAIL_PATH_NOT_FOUND;
        }
        if (err instanceof CasMismatchException) {
            return FAIL_CAS_MISMATCH;
        }
        if (ErrorClass.isFailTransient(err)) {
            return FAIL_TRANSIENT;
        }
        if (ErrorClass.isFailAmbiguous(err)) {
            return FAIL_AMBIGUOUS;
        }
        if (ErrorClass.isFailHard(err)) {
            return FAIL_HARD;
        }
        if (err instanceof AttemptExpiredException) {
            return FAIL_EXPIRY;
        }
        if (err instanceof ValueTooLargeException) {
            return FAIL_ATR_FULL;
        }
        return FAIL_OTHER;
    }

    public static boolean isFailTransient(Throwable e) {
        return e instanceof CasMismatchException || e instanceof UnambiguousTimeoutException || e instanceof TemporaryFailureException || e instanceof DurableWriteInProgressException || e instanceof TestFailTransientException;
    }

    public static boolean isFailHard(Throwable e) {
        return e instanceof TestFailHardException || e instanceof AssertionError;
    }

    public static boolean isFailAmbiguous(Throwable e) {
        return e instanceof DurabilityAmbiguousException || e instanceof AmbiguousTimeoutException || e instanceof RequestCanceledException || e instanceof TestFailAmbiguousException;
    }
}

