/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.Transcoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GetOptions
extends CommonOptions<GetOptions> {
    private boolean withExpiry = false;
    private List<String> projections;
    private Transcoder transcoder;

    public static GetOptions getOptions() {
        return new GetOptions();
    }

    private GetOptions() {
    }

    public GetOptions withExpiry(boolean expiry) {
        this.withExpiry = expiry;
        return this;
    }

    public GetOptions project(String path, String ... morePaths) {
        return this.project(Collections.singletonList(path)).project(Arrays.asList(morePaths));
    }

    public GetOptions project(Iterable<String> paths) {
        if (this.projections == null) {
            this.projections = new ArrayList<String>();
        }
        for (String path : paths) {
            if (CbStrings.isNullOrEmpty((String)path)) continue;
            this.projections.add(path);
        }
        return this;
    }

    public GetOptions transcoder(Transcoder transcoder) {
        Validators.notNull((Object)transcoder, (String)"Transcoder");
        this.transcoder = transcoder;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    @Stability.Internal
    public class Built
    extends CommonOptions.BuiltCommonOptions {
        Built() {
        }

        public boolean withExpiry() {
            return GetOptions.this.withExpiry;
        }

        public List<String> projections() {
            return GetOptions.this.projections == null ? Collections.emptyList() : GetOptions.this.projections;
        }

        public Transcoder transcoder() {
            return GetOptions.this.transcoder;
        }
    }
}

