/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.PhraseQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import java.util.List;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CorePhraseQuery
extends CoreSearchQuery {
    private final List<String> terms;
    @Nullable
    private final String field;

    public CorePhraseQuery(List<String> terms, @Nullable String field, @Nullable Double boost) {
        super(boost);
        this.terms = Validators.notNullOrEmpty(terms, "Terms");
        this.field = field;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        ArrayNode json = Mapper.createArrayNode();
        this.terms.forEach(json::add);
        input.set("terms", json);
        if (this.field != null) {
            input.put("field", this.field);
        }
    }

    @Override
    public Query asProtostellar() {
        PhraseQuery.Builder builder = PhraseQuery.newBuilder().addAllTerms(this.terms);
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setPhraseQuery(builder).build();
    }
}

