/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.service.ServiceType;

public class FeatureNotAvailableException
extends CouchbaseException {
    public FeatureNotAvailableException(String message) {
        super(message);
    }

    public FeatureNotAvailableException(String message, Throwable cause) {
        super(message, cause);
    }

    public FeatureNotAvailableException(Throwable cause) {
        super(cause);
    }

    public static FeatureNotAvailableException clusterLevelQuery(ServiceType serviceType) {
        return new FeatureNotAvailableException("The cluster does not support cluster-level queries (only Couchbase Server 6.5 and later) and no bucket is open. If an older Couchbase Server version is used, at least one bucket needs to be opened to dispatch this " + serviceType.ident() + " request!");
    }

    public static FeatureNotAvailableException scopeLevelQuery(ServiceType serviceType) {
        return new FeatureNotAvailableException("Scope-Level queries for the " + (Object)((Object)serviceType) + " service are not supported on the connected cluster (Only supported with Couchbase Server 7.0 and later).");
    }

    public static FeatureNotAvailableException queryPreserveExpiry() {
        return new FeatureNotAvailableException("Preserving expiry for the query service is not supported on the connected cluster (Only supported with Couchbase Server 7.1 and later).");
    }

    public static FeatureNotAvailableException collections() {
        return new FeatureNotAvailableException("The cluster does not support collections and scopes.");
    }

    public static FeatureNotAvailableException collectionsForMemcached() {
        return new FeatureNotAvailableException("Non-Default collections are not supported for memcached buckets.");
    }

    public static FeatureNotAvailableException communityEdition(String feature) {
        String f = feature == null || feature.isEmpty() ? "" : " [" + feature + "]";
        return new FeatureNotAvailableException("The feature" + f + " is not supported in the Community Edition (CE) of Couchbase Server.");
    }

    public static FeatureNotAvailableException rangeScan() {
        return new FeatureNotAvailableException("The cluster does not support the scan operation (Only supported with Couchbase Server 7.5 and later).");
    }

    public static CouchbaseException queryUseReplica(String message) {
        return new FeatureNotAvailableException("The cluster does not support the option use_replica (Only supported with Couchbase Server 7.6 and later). " + message);
    }

    public static CouchbaseException subdocReadReplica() {
        return new FeatureNotAvailableException("The cluster does not support reading subdocuments from replica (Only supported with Couchbase Server 7.5 and later and in clusters with replicas). ");
    }
}

