/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.kv;

import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreExpiry;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.util.Validators;
import java.util.Optional;
import java.util.function.Supplier;

public class CoreKvBinaryParamValidators {
    public static void validateAppendPrependArgs(String key, CoreKeyspace keyspace, CoreCommonOptions options, byte[] content, long cas, CoreDurability durability) {
        Supplier<ErrorContext> supplier = () -> ReducedKeyValueErrorContext.create(key, keyspace.toCollectionIdentifier());
        Validators.notNullOrEmpty(key, "Id", supplier);
        Validators.notNull(keyspace, "Keyspace", supplier);
        Validators.notNull(options, "Options", supplier);
        Validators.notNull(content, "Content", supplier);
        Validators.notNull(durability, "Durability", supplier);
    }

    public static void validateIncrementDecrementArgs(String key, CoreKeyspace keyspace, CoreCommonOptions options, CoreExpiry expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        Supplier<ErrorContext> supplier = () -> ReducedKeyValueErrorContext.create(key, keyspace.toCollectionIdentifier());
        Validators.notNullOrEmpty(key, "Id", supplier);
        Validators.notNull(keyspace, "Keyspace", supplier);
        Validators.notNull(options, "Options", supplier);
        Validators.notNull(initial, "Initial", supplier);
        Validators.notNull(durability, "Durability", supplier);
        Validators.notNull(expiry, "Expiry", supplier);
    }
}

