/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.kv;

import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.util.Bytes;
import java.nio.charset.StandardCharsets;
import reactor.util.annotation.Nullable;

public class CoreSubdocMutateCommand {
    private final SubdocCommandType type;
    private final String path;
    private final byte[] fragment;
    private final boolean createParent;
    private final boolean xattr;
    private final boolean expandMacro;

    public CoreSubdocMutateCommand(SubdocCommandType type, String path, @Nullable byte[] fragment, boolean createParent, boolean xattr, boolean expandMacro) {
        this.type = type;
        this.path = path;
        this.fragment = fragment == null ? Bytes.EMPTY_BYTE_ARRAY : fragment;
        this.createParent = createParent;
        this.xattr = xattr;
        this.expandMacro = expandMacro;
    }

    public SubdocCommandType type() {
        return this.type;
    }

    public String path() {
        return this.path;
    }

    public byte[] fragment() {
        return this.fragment;
    }

    public boolean createParent() {
        return this.createParent;
    }

    public boolean xattr() {
        return this.xattr;
    }

    public boolean expandMacro() {
        return this.expandMacro;
    }

    public String toString() {
        return "CoreSubdocMutateCommand{type=" + (Object)((Object)this.type) + ", path='" + this.path + '\'' + ", fragment=" + RedactableArgument.redactUser(new String(this.fragment, StandardCharsets.UTF_8)) + ", createParent=" + this.createParent + ", xattr=" + this.xattr + ", expandMacro=" + this.expandMacro + '}';
    }
}

