/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6;

import com.couchbase.client.core.deps.io.grpc.Contexts;
import com.couchbase.client.core.deps.io.grpc.ForwardingServerCall;
import com.couchbase.client.core.deps.io.grpc.ForwardingServerCallListener;
import com.couchbase.client.core.deps.io.grpc.Grpc;
import com.couchbase.client.core.deps.io.grpc.Metadata;
import com.couchbase.client.core.deps.io.grpc.ServerCall;
import com.couchbase.client.core.deps.io.grpc.ServerCallHandler;
import com.couchbase.client.core.deps.io.grpc.ServerInterceptor;
import com.couchbase.client.core.deps.io.grpc.Status;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcHelper;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class TracingServerInterceptor
implements ServerInterceptor {
    private static final AtomicLongFieldUpdater<TracingServerCall> MESSAGE_ID_UPDATER = AtomicLongFieldUpdater.newUpdater(TracingServerCall.class, "messageId");
    private final Instrumenter<GrpcRequest, Status> instrumenter;
    private final boolean captureExperimentalSpanAttributes;

    TracingServerInterceptor(Instrumenter<GrpcRequest, Status> instrumenter, boolean captureExperimentalSpanAttributes) {
        this.instrumenter = instrumenter;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
    }

    public <REQUEST, RESPONSE> ServerCall.Listener<REQUEST> interceptCall(ServerCall<REQUEST, RESPONSE> call, Metadata headers, ServerCallHandler<REQUEST, RESPONSE> next) {
        TracingServerCall.TracingServerCallListener tracingServerCallListener;
        block9: {
            GrpcRequest request = new GrpcRequest(call.getMethodDescriptor(), headers, call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR), call.getAuthority());
            Context parentContext = Context.current();
            if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
                return next.startCall(call, headers);
            }
            Context context = this.instrumenter.start(parentContext, (Object)request);
            Scope ignored = context.makeCurrent();
            try {
                tracingServerCallListener = new TracingServerCall<REQUEST, RESPONSE>(call, context, request).start(headers, next);
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    this.instrumenter.end(context, (Object)request, (Object)Status.UNKNOWN, e);
                    throw e;
                }
            }
            ignored.close();
        }
        return tracingServerCallListener;
    }

    final class TracingServerCall<REQUEST, RESPONSE>
    extends ForwardingServerCall.SimpleForwardingServerCall<REQUEST, RESPONSE> {
        private final Context context;
        private final GrpcRequest request;
        volatile long messageId;

        TracingServerCall(ServerCall<REQUEST, RESPONSE> delegate, Context context, GrpcRequest request) {
            super(delegate);
            this.context = context;
            this.request = request;
        }

        TracingServerCallListener start(Metadata headers, ServerCallHandler<REQUEST, RESPONSE> next) {
            return new TracingServerCallListener(Contexts.interceptCall(com.couchbase.client.core.deps.io.grpc.Context.current(), this, headers, next), this.context, this.request);
        }

        @Override
        public void sendMessage(RESPONSE message) {
            try (Scope ignored = this.context.makeCurrent();){
                super.sendMessage(message);
            }
            Span span = Span.fromContext((Context)this.context);
            Attributes attributes = Attributes.of(GrpcHelper.MESSAGE_TYPE, (Object)"SENT", GrpcHelper.MESSAGE_ID, (Object)MESSAGE_ID_UPDATER.incrementAndGet(this));
            span.addEvent("message", attributes);
        }

        @Override
        public void close(Status status, Metadata trailers) {
            try {
                this.delegate().close(status, trailers);
            }
            catch (Throwable e) {
                TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)status, e);
                throw e;
            }
            TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)status, status.getCause());
        }

        final class TracingServerCallListener
        extends ForwardingServerCallListener.SimpleForwardingServerCallListener<REQUEST> {
            private final Context context;
            private final GrpcRequest request;

            TracingServerCallListener(ServerCall.Listener<REQUEST> delegate, Context context, GrpcRequest request) {
                super(delegate);
                this.context = context;
                this.request = request;
            }

            @Override
            public void onMessage(REQUEST message) {
                Attributes attributes = Attributes.of(GrpcHelper.MESSAGE_TYPE, (Object)"RECEIVED", GrpcHelper.MESSAGE_ID, (Object)MESSAGE_ID_UPDATER.incrementAndGet(TracingServerCall.this));
                Span.fromContext((Context)this.context).addEvent("message", attributes);
                this.delegate().onMessage(message);
            }

            @Override
            public void onHalfClose() {
                try {
                    this.delegate().onHalfClose();
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.UNKNOWN, e);
                    throw e;
                }
            }

            @Override
            public void onCancel() {
                try {
                    this.delegate().onCancel();
                    if (TracingServerInterceptor.this.captureExperimentalSpanAttributes) {
                        Span.fromContext((Context)this.context).setAttribute("grpc.canceled", true);
                    }
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.UNKNOWN, e);
                    throw e;
                }
                TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.CANCELLED, null);
            }

            @Override
            public void onComplete() {
                try {
                    this.delegate().onComplete();
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.UNKNOWN, e);
                    throw e;
                }
            }

            @Override
            public void onReady() {
                try {
                    this.delegate().onReady();
                }
                catch (Throwable e) {
                    TracingServerInterceptor.this.instrumenter.end(this.context, (Object)this.request, (Object)Status.UNKNOWN, e);
                    throw e;
                }
            }
        }
    }
}

