/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.env.ClusterEnvironment;
import java.util.function.Consumer;

public class ClusterOptions {
    private ClusterEnvironment environment;
    private Consumer<ClusterEnvironment.Builder> environmentCustomizer;
    private final Authenticator authenticator;
    private static final String environmentAlreadyConfigured = "environment(ClusterEnvironment) and environment(Consumer<ClusterEnvironment.Builder>) are mutually exclusive; call one or the other, but not both.";

    private ClusterOptions(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public static ClusterOptions clusterOptions(Authenticator authenticator) {
        Validators.notNull((Object)authenticator, (String)"Authenticator");
        return new ClusterOptions(authenticator);
    }

    public static ClusterOptions clusterOptions(String username, String password) {
        Validators.notNullOrEmpty((String)username, (String)"Username");
        Validators.notNullOrEmpty((String)password, (String)"Password");
        return ClusterOptions.clusterOptions((Authenticator)PasswordAuthenticator.create((String)username, (String)password));
    }

    public ClusterOptions environment(ClusterEnvironment environment) {
        Validators.notNull((Object)((Object)environment), (String)"ClusterEnvironment");
        if (this.environmentCustomizer != null) {
            throw new IllegalStateException(environmentAlreadyConfigured);
        }
        this.environment = environment;
        return this;
    }

    @Stability.Uncommitted
    public ClusterOptions environment(Consumer<ClusterEnvironment.Builder> environmentCustomizer) {
        Validators.notNull(environmentCustomizer, (String)"environmentCustomizer");
        if (this.environment != null) {
            throw new IllegalStateException(environmentAlreadyConfigured);
        }
        if (this.environmentCustomizer != null) {
            throw new IllegalStateException("environment(Consumer<ClusterEnvironment.Builder>) may only be called once.");
        }
        this.environmentCustomizer = environmentCustomizer;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built {
        Built() {
        }

        public Authenticator authenticator() {
            return ClusterOptions.this.authenticator;
        }

        public ClusterEnvironment environment() {
            return ClusterOptions.this.environment;
        }

        public Consumer<ClusterEnvironment.Builder> environmentCustomizer() {
            return ClusterOptions.this.environmentCustomizer;
        }
    }
}

