/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreReactiveQueryResult;
import com.couchbase.client.core.api.search.CoreSearchOptions;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.result.CoreReactiveSearchResult;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.error.context.ReducedAnalyticsErrorContext;
import com.couchbase.client.core.error.context.ReducedQueryErrorContext;
import com.couchbase.client.core.error.context.ReducedSearchErrorContext;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.core.util.ConnectionStringUtil;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.ReactiveBucket;
import com.couchbase.client.java.analytics.AnalyticsAccessor;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.ReactiveAnalyticsResult;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.diagnostics.DiagnosticsOptions;
import com.couchbase.client.java.diagnostics.PingOptions;
import com.couchbase.client.java.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.http.ReactiveCouchbaseHttpClient;
import com.couchbase.client.java.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.java.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.java.manager.eventing.ReactiveEventingFunctionManager;
import com.couchbase.client.java.manager.query.ReactiveQueryIndexManager;
import com.couchbase.client.java.manager.search.ReactiveSearchIndexManager;
import com.couchbase.client.java.manager.user.ReactiveUserManager;
import com.couchbase.client.java.query.QueryAccessor;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.ReactiveQueryResult;
import com.couchbase.client.java.search.SearchOptions;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.result.ReactiveSearchResult;
import com.couchbase.client.java.transactions.ReactiveTransactions;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class ReactiveCluster {
    static final QueryOptions DEFAULT_QUERY_OPTIONS = QueryOptions.queryOptions();
    static final SearchOptions DEFAULT_SEARCH_OPTIONS = SearchOptions.searchOptions();
    static final AnalyticsOptions DEFAULT_ANALYTICS_OPTIONS = AnalyticsOptions.analyticsOptions();
    static final DiagnosticsOptions DEFAULT_DIAGNOSTICS_OPTIONS = DiagnosticsOptions.diagnosticsOptions();
    static final WaitUntilReadyOptions DEFAULT_WAIT_UNTIL_READY_OPTIONS = WaitUntilReadyOptions.waitUntilReadyOptions();
    static final PingOptions DEFAULT_PING_OPTIONS = PingOptions.pingOptions();
    private final AsyncCluster asyncCluster;
    private final Map<String, ReactiveBucket> bucketCache = new ConcurrentHashMap<String, ReactiveBucket>();

    public static ReactiveCluster connect(String connectionString, String username, String password) {
        return ReactiveCluster.connect(connectionString, ClusterOptions.clusterOptions((Authenticator)PasswordAuthenticator.create((String)username, (String)password)));
    }

    public static ReactiveCluster connect(String connectionString, ClusterOptions options) {
        Validators.notNullOrEmpty((String)connectionString, (String)"ConnectionString");
        Validators.notNull((Object)options, (String)"ClusterOptions");
        ClusterOptions.Built opts = options.build();
        ConnectionString connStr = ConnectionString.create((String)connectionString);
        Supplier<ClusterEnvironment> environmentSupplier = AsyncCluster.extractClusterEnvironment(connStr, opts);
        return new ReactiveCluster(environmentSupplier, opts.authenticator(), connStr);
    }

    public static ReactiveCluster connect(Set<SeedNode> seedNodes, ClusterOptions options) {
        return ReactiveCluster.connect(ConnectionStringUtil.asConnectionString(seedNodes).original(), options);
    }

    private ReactiveCluster(Supplier<ClusterEnvironment> environment, Authenticator authenticator, ConnectionString connectionString) {
        this(new AsyncCluster(environment, authenticator, connectionString));
    }

    ReactiveCluster(AsyncCluster asyncCluster) {
        this.asyncCluster = asyncCluster;
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncCluster.core();
    }

    @Stability.Volatile
    public ReactiveCouchbaseHttpClient httpClient() {
        return new ReactiveCouchbaseHttpClient(this.asyncCluster.httpClient());
    }

    public ReactiveUserManager users() {
        return new ReactiveUserManager(this.asyncCluster.users());
    }

    public ReactiveBucketManager buckets() {
        return new ReactiveBucketManager(this.async().buckets());
    }

    public ReactiveAnalyticsIndexManager analyticsIndexes() {
        return new ReactiveAnalyticsIndexManager(this.async());
    }

    public ReactiveSearchIndexManager searchIndexes() {
        return new ReactiveSearchIndexManager(this.async().searchIndexes());
    }

    public ReactiveQueryIndexManager queryIndexes() {
        return new ReactiveQueryIndexManager(this.async().queryIndexes());
    }

    @Stability.Uncommitted
    public ReactiveEventingFunctionManager eventingFunctions() {
        return new ReactiveEventingFunctionManager(this.async().eventingFunctions());
    }

    public AsyncCluster async() {
        return this.asyncCluster;
    }

    public ClusterEnvironment environment() {
        return this.asyncCluster.environment();
    }

    public Mono<ReactiveQueryResult> query(String statement) {
        return this.query(statement, DEFAULT_QUERY_OPTIONS);
    }

    public Mono<ReactiveQueryResult> query(String statement, QueryOptions options) {
        Validators.notNull((Object)options, (String)"QueryOptions", () -> new ReducedQueryErrorContext(statement));
        QueryOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
        return this.async().queryOps.queryReactive(statement, (CoreQueryOptions)opts, null, null, QueryAccessor::convertCoreQueryError).map(result -> new ReactiveQueryResult((CoreReactiveQueryResult)result, serializer));
    }

    public Mono<ReactiveAnalyticsResult> analyticsQuery(String statement) {
        return this.analyticsQuery(statement, DEFAULT_ANALYTICS_OPTIONS);
    }

    public Mono<ReactiveAnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Validators.notNull((Object)options, (String)"AnalyticsOptions", () -> new ReducedAnalyticsErrorContext(statement));
        AnalyticsOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
        return Mono.defer(() -> AnalyticsAccessor.analyticsQueryReactive(this.asyncCluster.core(), this.asyncCluster.analyticsRequest(statement, opts), serializer));
    }

    public Mono<ReactiveSearchResult> searchQuery(String indexName, SearchQuery query) {
        return this.searchQuery(indexName, query, DEFAULT_SEARCH_OPTIONS);
    }

    public Mono<ReactiveSearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        Validators.notNull((Object)query, (String)"SearchQuery", () -> new ReducedSearchErrorContext(indexName, null));
        CoreSearchQuery coreQuery = query.toCore();
        Validators.notNull((Object)options, (String)"SearchOptions", () -> new ReducedSearchErrorContext(indexName, coreQuery));
        SearchOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
        return this.asyncCluster.searchOps.searchQueryReactive(indexName, coreQuery, (CoreSearchOptions)opts).map(result -> new ReactiveSearchResult((CoreReactiveSearchResult)result, serializer));
    }

    public ReactiveBucket bucket(String bucketName) {
        return this.bucketCache.computeIfAbsent(bucketName, n -> new ReactiveBucket(this.asyncCluster.bucket((String)n)));
    }

    public Mono<Void> disconnect() {
        return this.disconnect(this.environment().timeoutConfig().disconnectTimeout());
    }

    public Mono<Void> disconnect(Duration timeout) {
        return this.asyncCluster.disconnectInternal(timeout);
    }

    public Mono<DiagnosticsResult> diagnostics() {
        return this.diagnostics(DEFAULT_DIAGNOSTICS_OPTIONS);
    }

    public Mono<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return Mono.defer(() -> Mono.fromFuture(this.asyncCluster.diagnostics(options)));
    }

    public Mono<PingResult> ping() {
        return this.ping(DEFAULT_PING_OPTIONS);
    }

    public Mono<PingResult> ping(PingOptions options) {
        return Mono.defer(() -> Mono.fromFuture(this.asyncCluster.ping(options)));
    }

    public Mono<Void> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, DEFAULT_WAIT_UNTIL_READY_OPTIONS);
    }

    public Mono<Void> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return Mono.defer(() -> Mono.fromFuture(this.asyncCluster.waitUntilReady(timeout, options)));
    }

    @Stability.Uncommitted
    public ReactiveTransactions transactions() {
        return new ReactiveTransactions(this.core(), this.environment().jsonSerializer());
    }
}

