/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.http;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.http.AsyncCouchbaseHttpClient;
import com.couchbase.client.java.http.HttpDeleteOptions;
import com.couchbase.client.java.http.HttpGetOptions;
import com.couchbase.client.java.http.HttpPath;
import com.couchbase.client.java.http.HttpPostOptions;
import com.couchbase.client.java.http.HttpPutOptions;
import com.couchbase.client.java.http.HttpResponse;
import com.couchbase.client.java.http.HttpTarget;
import java.util.Objects;

public class CouchbaseHttpClient {
    private final AsyncCouchbaseHttpClient async;

    @Stability.Internal
    public CouchbaseHttpClient(AsyncCouchbaseHttpClient async) {
        this.async = Objects.requireNonNull(async);
    }

    public HttpResponse get(HttpTarget target, HttpPath path) {
        return AsyncUtils.block(this.async.get(target, path));
    }

    public HttpResponse get(HttpTarget target, HttpPath path, HttpGetOptions options) {
        return AsyncUtils.block(this.async.get(target, path, options));
    }

    public HttpResponse post(HttpTarget target, HttpPath path) {
        return AsyncUtils.block(this.async.post(target, path));
    }

    public HttpResponse post(HttpTarget target, HttpPath path, HttpPostOptions options) {
        return AsyncUtils.block(this.async.post(target, path, options));
    }

    public HttpResponse put(HttpTarget target, HttpPath path) {
        return AsyncUtils.block(this.async.put(target, path));
    }

    public HttpResponse put(HttpTarget target, HttpPath path, HttpPutOptions options) {
        return AsyncUtils.block(this.async.put(target, path, options));
    }

    public HttpResponse delete(HttpTarget target, HttpPath path) {
        return AsyncUtils.block(this.async.delete(target, path));
    }

    public HttpResponse delete(HttpTarget target, HttpPath path, HttpDeleteOptions options) {
        return AsyncUtils.block(this.async.delete(target, path, options));
    }
}

