/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.json;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonNull;
import com.couchbase.client.java.json.JsonObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public abstract class JsonValue {
    public static final JsonNull NULL = JsonNull.INSTANCE;

    public static JsonObject jo() {
        return JsonObject.create();
    }

    public static JsonArray ja() {
        return JsonArray.create();
    }

    public static boolean checkType(Object item) {
        return item == null || item instanceof String || item instanceof Integer || item instanceof Long || item instanceof Double || item instanceof Boolean || item instanceof BigInteger || item instanceof BigDecimal || item instanceof JsonObject || item instanceof JsonArray;
    }

    @Stability.Internal
    public static Object coerce(Object value) {
        if (JsonValue.checkType(value)) {
            return value;
        }
        if (value instanceof Map) {
            return JsonObject.from((Map)value);
        }
        if (value instanceof List) {
            return JsonArray.from((List)value);
        }
        if (value instanceof JsonNull) {
            return null;
        }
        throw InvalidArgumentException.fromMessage((String)("Unsupported type for JSON value: " + value.getClass()));
    }
}

