/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import reactor.util.Logger;
import reactor.util.Loggers;

final class ContextPropagationSupport {
    static final Logger LOGGER = Loggers.getLogger(ContextPropagationSupport.class);
    static final boolean isContextPropagationOnClasspath;
    static final boolean isContextPropagation103OnClasspath;
    static boolean propagateContextToThreadLocals;

    ContextPropagationSupport() {
    }

    static boolean isContextPropagationAvailable() {
        return isContextPropagationOnClasspath;
    }

    static boolean isContextPropagation103Available() {
        return isContextPropagation103OnClasspath;
    }

    static boolean shouldPropagateContextToThreadLocals() {
        return isContextPropagationOnClasspath && propagateContextToThreadLocals;
    }

    static boolean shouldRestoreThreadLocalsInSomeOperators() {
        return isContextPropagationOnClasspath && !propagateContextToThreadLocals;
    }

    static {
        propagateContextToThreadLocals = false;
        boolean contextPropagation = false;
        boolean contextPropagation103 = false;
        try {
            Class.forName("io.micrometer.context.ContextRegistry");
            contextPropagation = true;
            Class.forName("io.micrometer.context.ContextSnapshotFactory");
            contextPropagation103 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (Throwable err) {
            LOGGER.error("Unexpected exception while detecting ContextPropagation feature. The feature is considered disabled due to this:", err);
        }
        isContextPropagationOnClasspath = contextPropagation;
        isContextPropagation103OnClasspath = contextPropagation103;
    }
}

