/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6;

import com.couchbase.client.core.deps.io.grpc.Metadata;
import com.couchbase.client.core.deps.io.grpc.MethodDescriptor;
import java.net.SocketAddress;
import java.net.URI;
import javax.annotation.Nullable;

public final class GrpcRequest {
    private final MethodDescriptor<?, ?> method;
    @Nullable
    private volatile Metadata metadata;
    @Nullable
    private volatile String logicalHost;
    private volatile int logicalPort = -1;
    @Nullable
    private volatile SocketAddress peerSocketAddress;

    GrpcRequest(MethodDescriptor<?, ?> method, @Nullable Metadata metadata, @Nullable SocketAddress peerSocketAddress, @Nullable String authority) {
        this.method = method;
        this.metadata = metadata;
        this.peerSocketAddress = peerSocketAddress;
        this.setLogicalAddress(authority);
    }

    private void setLogicalAddress(@Nullable String authority) {
        if (authority == null) {
            return;
        }
        try {
            URI uri = new URI(null, authority, null, null, null);
            this.logicalHost = uri.getHost();
            this.logicalPort = uri.getPort();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public MethodDescriptor<?, ?> getMethod() {
        return this.method;
    }

    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Nullable
    public String getLogicalHost() {
        return this.logicalHost;
    }

    public int getLogicalPort() {
        return this.logicalPort;
    }

    @Nullable
    public SocketAddress getPeerSocketAddress() {
        return this.peerSocketAddress;
    }

    void setPeerSocketAddress(SocketAddress peerSocketAddress) {
        this.peerSocketAddress = peerSocketAddress;
    }
}

