/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.internal;

import com.couchbase.client.core.deps.io.grpc.Context;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.Scope;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ContextStorageBridge
extends Context.Storage {
    private static final Logger logger = Logger.getLogger(ContextStorageBridge.class.getName());
    private static final ContextKey<com.couchbase.client.core.deps.io.grpc.Context> GRPC_CONTEXT = ContextKey.named((String)"grpc-context");
    private static final Context.Key<Context> OTEL_CONTEXT = com.couchbase.client.core.deps.io.grpc.Context.key("otel-context");
    private static final Context.Key<Scope> OTEL_SCOPE = com.couchbase.client.core.deps.io.grpc.Context.key("otel-scope");
    private final boolean propagateGrpcDeadline;

    public ContextStorageBridge(boolean propagateGrpcDeadline) {
        this.propagateGrpcDeadline = propagateGrpcDeadline;
    }

    @Override
    public com.couchbase.client.core.deps.io.grpc.Context doAttach(com.couchbase.client.core.deps.io.grpc.Context toAttach) {
        Context otelContext = Context.current();
        com.couchbase.client.core.deps.io.grpc.Context current = (com.couchbase.client.core.deps.io.grpc.Context)otelContext.get(GRPC_CONTEXT);
        if (current == null) {
            current = com.couchbase.client.core.deps.io.grpc.Context.ROOT;
        }
        if (current == toAttach) {
            return current.withValue(OTEL_SCOPE, Scope.noop());
        }
        Context base = OTEL_CONTEXT.get(toAttach);
        Context newOtelContext = base != null ? base.with(GRPC_CONTEXT, (Object)toAttach) : Context.current().with(GRPC_CONTEXT, (Object)toAttach);
        Scope scope = newOtelContext.makeCurrent();
        return current.withValue(OTEL_SCOPE, scope);
    }

    @Override
    public void detach(com.couchbase.client.core.deps.io.grpc.Context toDetach, com.couchbase.client.core.deps.io.grpc.Context toRestore) {
        Scope scope = OTEL_SCOPE.get(toRestore);
        if (scope == null) {
            logger.log(Level.SEVERE, "Detaching context which was not attached.", new Throwable().fillInStackTrace());
        } else {
            scope.close();
        }
    }

    @Override
    public com.couchbase.client.core.deps.io.grpc.Context current() {
        Context otelContext = Context.current();
        com.couchbase.client.core.deps.io.grpc.Context current = (com.couchbase.client.core.deps.io.grpc.Context)otelContext.get(GRPC_CONTEXT);
        if (current == null) {
            return com.couchbase.client.core.deps.io.grpc.Context.ROOT.withValue(OTEL_CONTEXT, otelContext);
        }
        Context previousOtelContext = OTEL_CONTEXT.get(current);
        if (previousOtelContext != otelContext) {
            if (!this.propagateGrpcDeadline) {
                current = current.fork();
            }
            return current.withValue(OTEL_CONTEXT, otelContext);
        }
        return current;
    }
}

