/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.events.endpoint.EndpointDisconnectDelayedEvent;
import com.couchbase.client.core.cnc.events.endpoint.EndpointDisconnectResumedEvent;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.endpoint.PipelineInitializer;
import com.couchbase.client.core.io.netty.query.QueryHandlerSwitcher;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;

public class QueryEndpoint
extends BaseEndpoint {
    private volatile boolean closeWhenDone = false;

    public QueryEndpoint(ServiceContext ctx, String hostname, int port) {
        super(hostname, port, ctx.environment().ioEnvironment().queryEventLoopGroup().get(), ctx, ctx.environment().ioConfig().queryCircuitBreakerConfig(), ServiceType.QUERY, false);
    }

    @Override
    protected PipelineInitializer pipelineInitializer() {
        return new QueryPipelineInitializer(this.context());
    }

    @Override
    public synchronized void disconnect() {
        if (this.outstandingRequests() > 0L) {
            this.closeWhenDone();
        } else {
            super.disconnect();
        }
    }

    private void closeWhenDone() {
        this.closeWhenDone = true;
        ((EndpointContext)this.endpointContext.get()).environment().eventBus().publish(new EndpointDisconnectDelayedEvent((EndpointContext)this.endpointContext.get()));
    }

    @Override
    @Stability.Internal
    public synchronized void markRequestCompletion() {
        super.markRequestCompletion();
        if (this.closeWhenDone && this.outstandingRequests() <= 0L) {
            ((EndpointContext)this.endpointContext.get()).environment().eventBus().publish(new EndpointDisconnectResumedEvent((EndpointContext)this.endpointContext.get()));
            this.closeChannel(this.channel);
            this.closeWhenDone = false;
        }
    }

    public static class QueryPipelineInitializer
    implements PipelineInitializer {
        private final EndpointContext endpointContext;

        QueryPipelineInitializer(EndpointContext endpointContext) {
            this.endpointContext = endpointContext;
        }

        @Override
        public void init(BaseEndpoint endpoint, ChannelPipeline pipeline) {
            pipeline.addLast(new HttpClientCodec());
            pipeline.addLast(QueryHandlerSwitcher.SWITCHER_IDENTIFIER, (ChannelHandler)new QueryHandlerSwitcher(endpoint, this.endpointContext));
        }
    }
}

