/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase;

import io.jans.orm.couchbase.CouchbaseEntryManagerSample;
import io.jans.orm.couchbase.impl.CouchbaseEntryManager;
import io.jans.orm.couchbase.model.SimpleUser;
import io.jans.orm.couchbase.operation.impl.CouchbaseConnectionProvider;
import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.util.StringHelper;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CouchbaseCustomMultiValuedTypesSample {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);

    private CouchbaseCustomMultiValuedTypesSample() {
    }

    public static void main(String[] args) {
        CouchbaseEntryManagerSample couchbaseEntryManagerSample = new CouchbaseEntryManagerSample();
        CouchbaseEntryManager couchbaseEntryManager = couchbaseEntryManagerSample.createCouchbaseEntryManager();
        SimpleUser newUser = new SimpleUser();
        newUser.setDn(String.format("inum=%s,ou=people,o=jans", System.currentTimeMillis()));
        newUser.setUserId("sample_user_" + System.currentTimeMillis());
        newUser.setUserPassword("test");
        newUser.getCustomAttributes().add(new CustomObjectAttribute("streetAddress", Arrays.asList("London", "Texas", "Kiev")));
        newUser.getCustomAttributes().add(new CustomObjectAttribute("test", (Object)"test_value"));
        newUser.getCustomAttributes().add(new CustomObjectAttribute("fuzzy", (Object)"test_value"));
        newUser.setMemberOf(Arrays.asList("group_1", "group_2", "group_3"));
        newUser.setAttributeValue("givenName", "john");
        couchbaseEntryManager.persist((Object)newUser);
        LOG.info("Added User '{}' with uid '{}' and key '{}'", new Object[]{newUser, newUser.getUserId(), newUser.getDn()});
        LOG.info("Persisted custom attributes '{}'", newUser.getCustomAttributes());
        SimpleUser foundUser = (SimpleUser)couchbaseEntryManager.find(SimpleUser.class, (Object)newUser.getDn());
        LOG.info("Found User '{}' with uid '{}' and key '{}'", new Object[]{foundUser, foundUser.getUserId(), foundUser.getDn()});
        LOG.info("Custom attributes '{}'", foundUser.getCustomAttributes());
        foundUser.setAttributeValues("streetAddress", Arrays.asList("London", "Texas", "Kiev", "Dublin"));
        foundUser.setAttributeValues("test", Arrays.asList("test_value_1", "test_value_2", "test_value_3", "test_value_4"));
        foundUser.setAttributeValues("fuzzy", Arrays.asList("fuzzy_value_1", "fuzzy_value_2"));
        foundUser.setAttributeValue("simple", "simple");
        CustomObjectAttribute multiValuedSingleValue = new CustomObjectAttribute("multivalued", (Object)"multivalued_single_valued");
        multiValuedSingleValue.setMultiValued(true);
        foundUser.getCustomAttributes().add(multiValuedSingleValue);
        couchbaseEntryManager.merge((Object)foundUser);
        LOG.info("Updated custom attributes '{}'", foundUser.getCustomAttributes());
        SimpleUser foundUpdatedUser = (SimpleUser)couchbaseEntryManager.find(SimpleUser.class, (Object)newUser.getDn());
        LOG.info("Found User '{}' with uid '{}' and key '{}'", new Object[]{foundUpdatedUser, foundUpdatedUser.getUserId(), foundUpdatedUser.getDn()});
        LOG.info("Cusom attributes '{}'", foundUpdatedUser.getCustomAttributes());
        Filter filter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"givenName"), (Object)StringHelper.toLowerCase((String)"john"));
        List foundUpdatedUsers = couchbaseEntryManager.findEntries("ou=people,o=jans", SimpleUser.class, filter);
        System.out.println(foundUpdatedUsers);
    }
}

