/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase;

import io.jans.orm.couchbase.CouchbaseEntryManagerSample;
import io.jans.orm.couchbase.CouchbaseSample;
import io.jans.orm.couchbase.LoggingHelper;
import io.jans.orm.couchbase.impl.CouchbaseEntryManager;
import io.jans.orm.couchbase.model.SimpleCache;
import io.jans.orm.couchbase.model.SimpleSession;
import io.jans.orm.couchbase.model.SimpleToken;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.model.BatchOperation;
import io.jans.orm.model.DefaultBatchOperation;
import io.jans.orm.model.ProcessBatchOperation;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.base.CustomAttribute;
import io.jans.orm.search.filter.Filter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;

public final class CouchbaseBatchJobSample {
    private static final Logger LOG;

    private CouchbaseBatchJobSample() {
    }

    public static void main(String[] args) {
        CouchbaseEntryManagerSample couchbaseEntryManagerSample = new CouchbaseEntryManagerSample();
        final CouchbaseEntryManager couchbaseEntryManager = couchbaseEntryManagerSample.createCouchbaseEntryManager();
        ProcessBatchOperation<SimpleToken> tokenCouchbaseBatchOperation = new ProcessBatchOperation<SimpleToken>(){
            private int processedCount = 0;

            public void performAction(List<SimpleToken> objects) {
                for (SimpleToken simpleTokenCouchbase : objects) {
                    try {
                        CustomAttribute customAttribute = CouchbaseBatchJobSample.getUpdatedAttribute(couchbaseEntryManager, simpleTokenCouchbase.getDn(), "exp", simpleTokenCouchbase.getAttribute("exp"));
                        simpleTokenCouchbase.setCustomAttributes(Arrays.asList(customAttribute));
                        couchbaseEntryManager.merge((Object)simpleTokenCouchbase);
                        ++this.processedCount;
                    }
                    catch (EntryPersistenceException ex) {
                        LOG.error((Object)"Failed to update entry", (Throwable)ex);
                    }
                }
                LOG.info((Object)("Total processed: " + this.processedCount));
            }
        };
        Filter filter1 = Filter.createPresenceFilter((String)"exp");
        couchbaseEntryManager.findEntries("ou=tokens,o=jans", SimpleToken.class, filter1, SearchScope.SUB, new String[]{"exp"}, (BatchOperation)tokenCouchbaseBatchOperation, 0, 0, 100);
        ProcessBatchOperation<SimpleSession> sessionBatchOperation = new ProcessBatchOperation<SimpleSession>(){
            private int processedCount = 0;

            public void performAction(List<SimpleSession> objects) {
                for (SimpleSession simpleSession : objects) {
                    try {
                        CustomAttribute customAttribute = CouchbaseBatchJobSample.getUpdatedAttribute(couchbaseEntryManager, simpleSession.getDn(), "jansLastAccessTime", simpleSession.getAttribute("jansLastAccessTime"));
                        simpleSession.setCustomAttributes(Arrays.asList(customAttribute));
                        couchbaseEntryManager.merge((Object)simpleSession);
                        ++this.processedCount;
                    }
                    catch (EntryPersistenceException ex) {
                        LOG.error((Object)"Failed to update entry", (Throwable)ex);
                    }
                }
                LOG.info((Object)("Total processed: " + this.processedCount));
            }
        };
        Filter filter2 = Filter.createPresenceFilter((String)"jansLastAccessTime");
        couchbaseEntryManager.findEntries("ou=sessions,o=jans", SimpleSession.class, filter2, SearchScope.SUB, new String[]{"jansLastAccessTime"}, (BatchOperation)sessionBatchOperation, 0, 0, 100);
        ProcessBatchOperation<SimpleCache> clientBatchOperation = new ProcessBatchOperation<SimpleCache>(){
            private int processedCount = 0;

            public void performAction(List<SimpleCache> objects) {
                for (SimpleCache simpleCache : objects) {
                    ++this.processedCount;
                }
                LOG.info((Object)("Total processed: " + this.processedCount));
            }
        };
        Filter filter3 = Filter.createPresenceFilter((String)"exp");
        List result3 = couchbaseEntryManager.findEntries("ou=cache,o=jans", SimpleCache.class, filter3, SearchScope.SUB, new String[]{"exp"}, (BatchOperation)clientBatchOperation, 0, 0, 333);
        LOG.info((Object)("Result count (without collecting results): " + result3.size()));
        DefaultBatchOperation<SimpleCache> clientBatchOperation2 = new DefaultBatchOperation<SimpleCache>(){
            private int processedCount = 0;

            public void performAction(List<SimpleCache> objects) {
                for (SimpleCache simpleCache : objects) {
                    ++this.processedCount;
                }
                LOG.info((Object)("Total processed: " + this.processedCount));
            }
        };
        Filter filter4 = Filter.createPresenceFilter((String)"exp");
        List result4 = couchbaseEntryManager.findEntries("ou=cache,o=jans", SimpleCache.class, filter4, SearchScope.SUB, new String[]{"exp"}, (BatchOperation)clientBatchOperation2, 0, 0, 333);
        LOG.info((Object)("Result count (with collecting results): " + result4.size()));
    }

    private static CustomAttribute getUpdatedAttribute(CouchbaseEntryManager couchbaseEntryManager, String baseDn, String attributeName, String attributeValue) {
        try {
            Calendar calendar = Calendar.getInstance();
            Date jansLastAccessTimeDate = new Date();
            calendar.setTime(jansLastAccessTimeDate);
            calendar.add(13, -1);
            CustomAttribute customAttribute = new CustomAttribute();
            customAttribute.setName(attributeName);
            customAttribute.setValue(couchbaseEntryManager.encodeTime(baseDn, calendar.getTime()));
            return customAttribute;
        }
        catch (Exception ex) {
            LOG.error((Object)"Can't parse attribute", (Throwable)ex);
            return null;
        }
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        LOG = Logger.getLogger(CouchbaseSample.class);
    }
}

