/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase;

import io.jans.orm.couchbase.CouchbaseEntryManagerSample;
import io.jans.orm.couchbase.impl.CouchbaseEntryManager;
import io.jans.orm.couchbase.model.SimpleUser;
import io.jans.orm.couchbase.operation.impl.CouchbaseConnectionProvider;
import io.jans.orm.search.filter.Filter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CouchbaseAuthenticationSample {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);

    private CouchbaseAuthenticationSample() {
    }

    public static void main(String[] args) {
        CouchbaseEntryManagerSample couchbaseEntryManagerSample = new CouchbaseEntryManagerSample();
        CouchbaseEntryManager couchbaseEntryManager = couchbaseEntryManagerSample.createCouchbaseEntryManager();
        List users = couchbaseEntryManager.findEntries("ou=people,o=gluu", SimpleUser.class, null);
        for (SimpleUser user : users) {
            LOG.info("User with uid: '{}' with DN: '{}'", (Object)user.getUserId(), (Object)user.getDn());
        }
        boolean authenticated = couchbaseEntryManager.authenticate("ou=people,o=gluu", SimpleUser.class, "test_user", "test_user_password");
        LOG.info("User with uid: '{}' with DN: '{}'", (Object)"test_user", (Object)authenticated);
        Filter userUidFilter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)"test_user");
        List foundUsers = couchbaseEntryManager.findEntries("ou=people,o=gluu", SimpleUser.class, userUidFilter);
        if (foundUsers.size() > 0) {
            SimpleUser user = (SimpleUser)foundUsers.get(0);
            LOG.info("Found uid: '{}' with custom attributes: '{}'", (Object)user.getUserId(), user.getCustomAttributes());
        }
    }
}

