/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase;

import io.jans.orm.couchbase.CouchbaseEntryManagerSample;
import io.jans.orm.couchbase.impl.CouchbaseEntryManager;
import io.jans.orm.couchbase.model.SimpleCustomStringUser;
import io.jans.orm.couchbase.model.UserRole;
import io.jans.orm.couchbase.operation.impl.CouchbaseConnectionProvider;
import io.jans.orm.model.base.CustomAttribute;
import io.jans.orm.search.filter.Filter;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CouchbaseCustomStringAttributesSample {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);

    private CouchbaseCustomStringAttributesSample() {
    }

    public static void main(String[] args) {
        CouchbaseEntryManagerSample couchbaseEntryManagerSample = new CouchbaseEntryManagerSample();
        CouchbaseEntryManager couchbaseEntryManager = couchbaseEntryManagerSample.createCouchbaseEntryManager();
        String randomExternalUid = "otp:" + System.currentTimeMillis();
        SimpleCustomStringUser newUser = new SimpleCustomStringUser();
        newUser.setDn(String.format("inum=%s,ou=people,o=jans", System.currentTimeMillis()));
        newUser.setUserId("sample_user_" + System.currentTimeMillis());
        newUser.setUserPassword("test");
        newUser.getCustomAttributes().add(new CustomAttribute("streetAddress", Arrays.asList("London", "Texas", "Kiev")).setMultiValued(false));
        newUser.getCustomAttributes().add(new CustomAttribute("jansExternalUid", randomExternalUid).setMultiValued(true));
        newUser.setUserRole(UserRole.ADMIN);
        newUser.setNotes(Arrays.asList("note 1", "note 2", "note 3"));
        couchbaseEntryManager.persist((Object)newUser);
        LOG.info("Added User '{}' with uid '{}' and key '{}'", new Object[]{newUser, newUser.getUserId(), newUser.getDn()});
        SimpleCustomStringUser foundUser = (SimpleCustomStringUser)couchbaseEntryManager.find(SimpleCustomStringUser.class, (Object)newUser.getDn());
        LOG.info("Found User '{}' with uid '{}' and key '{}'", new Object[]{foundUser, foundUser.getUserId(), foundUser.getDn()});
        LOG.info("Custom attributes '{}'", foundUser.getCustomAttributes());
        for (CustomAttribute customAttribute : foundUser.getCustomAttributes()) {
            LOG.info("Found custom attribute '{}' with value '{}'", (Object)customAttribute.getName(), (Object)customAttribute.getValues());
        }
        foundUser.setAttributeValues("streetAddress", Arrays.asList("London", "Texas", "Kiev"));
        couchbaseEntryManager.merge((Object)foundUser);
        LOG.info("Updated User '{}' with uid '{}' and key '{}'", new Object[]{foundUser, foundUser.getUserId(), foundUser.getDn()});
        SimpleCustomStringUser foundUser2 = (SimpleCustomStringUser)couchbaseEntryManager.find(SimpleCustomStringUser.class, (Object)foundUser.getDn());
        LOG.info("Found User '{}' with uid '{}' and key '{}'", new Object[]{foundUser, foundUser.getUserId(), foundUser.getDn()});
        LOG.info("Custom attributes '{}'", foundUser2.getCustomAttributes());
        for (CustomAttribute customAttribute : foundUser2.getCustomAttributes()) {
            LOG.info("Found custom attribute '{}' with value '{}'", (Object)customAttribute.getName(), (Object)customAttribute.getValues());
        }
        Filter filter = Filter.createEqualityFilter((String)"jansExternalUid", (Object)randomExternalUid).multiValued();
        List foundUsers = couchbaseEntryManager.findEntries("ou=people,o=jans", SimpleCustomStringUser.class, filter);
        for (SimpleCustomStringUser foundUser3 : foundUsers) {
            LOG.info("Found User '{}' by jsExternalUid with uid '{}' and key '{}'", new Object[]{foundUser3, foundUser3.getUserId(), foundUser3.getDn()});
        }
    }
}

