/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase;

import io.jans.orm.couchbase.CouchbaseEntryManagerSample;
import io.jans.orm.couchbase.impl.CouchbaseEntryManager;
import io.jans.orm.couchbase.model.SimpleSessionState;
import io.jans.orm.couchbase.operation.impl.CouchbaseConnectionProvider;
import io.jans.orm.exception.EntryPersistenceException;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CouchbaseUpateMissingEntrySample {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);

    private CouchbaseUpateMissingEntrySample() {
    }

    public static void main(String[] args) {
        CouchbaseEntryManagerSample sqlSampleEntryManager = new CouchbaseEntryManagerSample();
        CouchbaseEntryManager sqlEntryManager = sqlSampleEntryManager.createCouchbaseEntryManager();
        String sessionId = UUID.randomUUID().toString();
        String sessionDn = "uniqueIdentifier=" + sessionId + ",ou=session,o=jans";
        SimpleSessionState simpleSessionState = new SimpleSessionState();
        simpleSessionState.setDn(sessionDn);
        simpleSessionState.setId(sessionId);
        simpleSessionState.setLastUsedAt(new Date());
        try {
            sqlEntryManager.merge((Object)simpleSessionState);
            System.out.println("Updated");
        }
        catch (EntryPersistenceException ex) {
            LOG.info("Failed to update, root case exception: {}", ex.getCause().getClass(), (Object)ex);
            LOG.info("Test Passed :) It's right behaviour.");
        }
    }
}

