/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase;

import io.jans.orm.couchbase.CouchbaseEntryManagerSample;
import io.jans.orm.couchbase.LoggingHelper;
import io.jans.orm.couchbase.impl.CouchbaseEntryManager;
import io.jans.orm.couchbase.model.GluuStatus;
import io.jans.orm.couchbase.model.SimpleUser;
import io.jans.orm.model.base.CustomObjectAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;

public final class CouchbaseAddBulkUserSample {
    private static final Logger LOG;
    private static AtomicLong successResult;
    private static AtomicLong errorResult;
    private static AtomicLong totalTime;
    private static AtomicLong activeCount;

    private CouchbaseAddBulkUserSample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        CouchbaseEntryManagerSample couchbaseEntryManagerSample = new CouchbaseEntryManagerSample();
        final CouchbaseEntryManager couchbaseEntryManager = couchbaseEntryManagerSample.createCouchbaseEntryManager();
        int countUsers = 1000000;
        int threadCount = 200;
        int threadIterationCount = countUsers / threadCount;
        long totalStart = System.currentTimeMillis();
        try {
            ExecutorService executorService = Executors.newFixedThreadPool(threadCount, CouchbaseAddBulkUserSample.daemonThreadFactory());
            for (int i = 0; i < threadCount; ++i) {
                activeCount.incrementAndGet();
                final int count = i;
                executorService.execute(new AddUserRunnable(i * threadIterationCount, (i + 1) * threadIterationCount - 1){

                    @Override
                    public void run() {
                        long start = System.currentTimeMillis();
                        for (int j = this.startRange; j <= this.endRange; ++j) {
                            long userUid = j;
                            String name = String.format("user%06d", userUid);
                            String sn = String.format("lastname%06d", userUid);
                            String cn = String.format("%s %s", name, sn);
                            String mail = String.format("%s@gluu.org", name);
                            String dn = String.format("inum=%06d,ou=people,o=jans", userUid);
                            SimpleUser newUser = new SimpleUser();
                            newUser.setDn(dn);
                            newUser.setUserId(name);
                            newUser.setUserPassword("topsecret" + j);
                            newUser.setDisplayName(cn);
                            newUser.setMail(mail);
                            newUser.setStatus(GluuStatus.ACTIVE);
                            CustomObjectAttribute customAttribute = new CustomObjectAttribute("givenName", (Object)name);
                            newUser.getCustomAttributes().add(customAttribute);
                            newUser.setAttributeValue("sn", sn);
                            newUser.setAttributeValue("cn", cn);
                            try {
                                couchbaseEntryManager.persist((Object)newUser);
                                successResult.incrementAndGet();
                                continue;
                            }
                            catch (Throwable e) {
                                errorResult.incrementAndGet();
                                System.out.println("ERROR !!!, thread: " + count + ", uid: " + name + ", error:" + e.getMessage());
                                e.printStackTrace();
                            }
                        }
                        long end = System.currentTimeMillis();
                        long duration = end - start;
                        LOG.info((Object)("Thread " + count + " execution time: " + duration));
                        totalTime.addAndGet(duration);
                        activeCount.decrementAndGet();
                    }
                });
            }
            while (activeCount.get() != 0L) {
                Thread.sleep(1000L);
            }
        }
        finally {
            couchbaseEntryManager.destroy();
        }
        long totalEnd = System.currentTimeMillis();
        long duration = totalEnd - totalStart;
        LOG.info((Object)("Total execution time: " + duration + " after execution: " + threadCount * threadIterationCount));
        System.out.println(String.format("successResult: '%d', errorResult: '%d'", successResult.get(), errorResult.get()));
    }

    public static ThreadFactory daemonThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        LOG = Logger.getLogger(CouchbaseAddBulkUserSample.class);
        successResult = new AtomicLong(0L);
        errorResult = new AtomicLong(0L);
        totalTime = new AtomicLong(0L);
        activeCount = new AtomicLong(0L);
    }

    public static abstract class AddUserRunnable
    implements Runnable {
        protected int startRange;
        protected int endRange;

        public AddUserRunnable(int startRange, int endRange) {
            this.startRange = startRange;
            this.endRange = endRange;
        }
    }
}

