/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase;

import io.jans.orm.couchbase.CouchbaseEntryManagerSample;
import io.jans.orm.couchbase.LoggingHelper;
import io.jans.orm.couchbase.impl.CouchbaseEntryManager;
import io.jans.orm.couchbase.model.SimpleSessionState;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;

public final class CouchbaseConcurentSessionUpdateSample {
    private static final Logger LOG;

    private CouchbaseConcurentSessionUpdateSample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        CouchbaseEntryManagerSample couchbaseEntryManagerSample = new CouchbaseEntryManagerSample();
        final CouchbaseEntryManager couchbaseEntryManager = couchbaseEntryManagerSample.createCouchbaseEntryManager();
        try {
            String sessionId = "xyzcyzxy-a41a-45ad-8a83-61485dbad561";
            final String sessionDn = "uniqueIdentifier=" + sessionId + ",ou=session,o=jans";
            String userDn = "inum=sample_concurrent_user_1,ou=people,o=jans";
            SimpleSessionState simpleSessionState = new SimpleSessionState();
            simpleSessionState.setDn(sessionDn);
            simpleSessionState.setId(sessionId);
            simpleSessionState.setLastUsedAt(new Date());
            couchbaseEntryManager.persist((Object)simpleSessionState);
            System.out.println("Persisted");
            int threadCount = 500;
            ExecutorService executorService = Executors.newFixedThreadPool(threadCount, CouchbaseConcurentSessionUpdateSample.daemonThreadFactory());
            int i = 0;
            while (i < threadCount) {
                final int count = i++;
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        SimpleSessionState simpleSessionStateFromCouchbase = (SimpleSessionState)couchbaseEntryManager.find(SimpleSessionState.class, (Object)sessionDn);
                        String beforeUserDn = simpleSessionStateFromCouchbase.getUserDn();
                        String randomUserDn = count % 2 == 0 ? "inum=sample_concurrent_user_1,ou=people,o=jans" : "";
                        try {
                            simpleSessionStateFromCouchbase.setUserDn(randomUserDn);
                            simpleSessionStateFromCouchbase.setLastUsedAt(new Date());
                            couchbaseEntryManager.merge((Object)simpleSessionStateFromCouchbase);
                            System.out.println("Merged thread: " + count + ", userDn: " + randomUserDn + ", before userDn: " + beforeUserDn);
                        }
                        catch (Throwable e) {
                            System.out.println("ERROR !!!, thread: " + count + ", userDn: " + randomUserDn + ", before userDn: " + beforeUserDn + ", error:" + e.getMessage());
                        }
                    }
                });
            }
            Thread.sleep(5000L);
        }
        finally {
            couchbaseEntryManager.destroy();
        }
    }

    public static ThreadFactory daemonThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        LOG = Logger.getLogger(CouchbaseConcurentSessionUpdateSample.class);
    }
}

