/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase;

import io.jans.orm.couchbase.CouchbaseEntryManagerSample;
import io.jans.orm.couchbase.impl.CouchbaseEntryManager;
import io.jans.orm.couchbase.model.SimpleCache;
import io.jans.orm.couchbase.operation.impl.CouchbaseConnectionProvider;
import io.jans.orm.search.filter.Filter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CouchbaseDeleteSample {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);

    private CouchbaseDeleteSample() {
    }

    public static void main(String[] args) {
        CouchbaseEntryManagerSample couchbaseEntryManagerSample = new CouchbaseEntryManagerSample();
        CouchbaseEntryManager couchbaseEntryManager = couchbaseEntryManagerSample.createCouchbaseEntryManager();
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        GregorianCalendar pastCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        ((Calendar)pastCalendar).add(13, -60);
        Date past = pastCalendar.getTime();
        for (int i = 0; i < 1000; ++i) {
            String id = String.format("cache_%06d", i);
            String dn = String.format("id=%s,ou=cache,o=jans", id);
            SimpleCache newCache = new SimpleCache();
            newCache.setDn(dn);
            newCache.setId(id);
            newCache.setData("{'sample_data': 'sample_data_value'}");
            newCache.setExpirationDate(past);
            newCache.setDeletable(true);
            try {
                couchbaseEntryManager.persist((Object)newCache);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        String baseDn = "ou=cache,o=jans";
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"del", (Object)true), Filter.createLessOrEqualFilter((String)"exp", (Object)couchbaseEntryManager.encodeTime(baseDn, now))});
        int result = couchbaseEntryManager.remove(baseDn, SimpleCache.class, filter, 2000);
        System.out.println(result);
    }
}

