/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase;

import io.jans.orm.couchbase.CouchbaseEntryManagerSample;
import io.jans.orm.couchbase.impl.CouchbaseEntryManager;
import io.jans.orm.couchbase.model.SimpleAttribute;
import io.jans.orm.couchbase.model.SimpleSession;
import io.jans.orm.couchbase.model.SimpleToken;
import io.jans.orm.couchbase.model.SimpleUser;
import io.jans.orm.couchbase.operation.impl.CouchbaseConnectionProvider;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.SortOrder;
import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.orm.search.filter.Filter;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CouchbaseSample {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);

    private CouchbaseSample() {
    }

    public static void main(String[] args) {
        PagedResult listViewResponse;
        CouchbaseEntryManagerSample couchbaseEntryManagerSample = new CouchbaseEntryManagerSample();
        CouchbaseEntryManager couchbaseEntryManager = couchbaseEntryManagerSample.createCouchbaseEntryManager();
        SimpleUser newUser = new SimpleUser();
        newUser.setDn(String.format("inum=%s,ou=people,o=jans", System.currentTimeMillis()));
        newUser.setUserId("sample_user_" + System.currentTimeMillis());
        newUser.setUserPassword("test");
        newUser.getCustomAttributes().add(new CustomObjectAttribute("streetAddress", Arrays.asList("London", "Texas", "Kiev")));
        newUser.getCustomAttributes().add(new CustomObjectAttribute("test", (Object)"test_value"));
        couchbaseEntryManager.persist((Object)newUser);
        Filter orFilterWithLower = Filter.createORFilter((Filter[])new Filter[]{Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"description"), (Object)"test1"), Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"description"), (Object)"test2")});
        List usersWithOrFilter = couchbaseEntryManager.findEntries("ou=sessions,o=gluu", SimpleUser.class, orFilterWithLower);
        for (SimpleUser user : usersWithOrFilter) {
            LOG.info("User with uid: '{}' with DN: '{}'", (Object)user.getUserId(), (Object)user.getDn());
        }
        Filter orFilterWithLower2 = Filter.createORFilter((Filter[])new Filter[]{Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"description"), null, (String[])new String[]{"test1"}, null), Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"displayName"), null, (String[])new String[]{"test1"}, null)});
        List usersWithOrFilter2 = couchbaseEntryManager.findEntries("ou=sessions,o=gluu", SimpleUser.class, orFilterWithLower2);
        for (Object user : usersWithOrFilter2) {
            LOG.info("User with uid: '{}' with DN: '{}'", (Object)((SimpleUser)user).getUserId(), (Object)((SimpleUser)user).getDn());
        }
        List users = couchbaseEntryManager.findEntries("ou=people,o=jans", SimpleUser.class, null);
        for (SimpleUser user : users) {
            LOG.info("User with uid: '{}' with DN: '{}'", (Object)user.getUserId(), (Object)user.getDn());
        }
        if (users.size() > 0) {
            Object user;
            user = (SimpleUser)users.get(3);
            LOG.info("Updating: " + ((SimpleUser)user).getUserId());
            String[] values = new String[]{"Somewhere: " + System.currentTimeMillis(), "Somewhere2: " + System.currentTimeMillis()};
            ((SimpleUser)user).getCustomAttributes().add(new CustomObjectAttribute("streetAddress", Arrays.asList(values)));
            ((SimpleUser)user).getCustomAttributes().add(new CustomObjectAttribute("test", (Object)"test_value"));
            ((SimpleUser)user).getCustomAttributes().add(new CustomObjectAttribute("test2", (Object)"test_value2"));
            ((SimpleUser)user).getCustomAttributes().add(new CustomObjectAttribute("test3", (Object)"test_value3"));
            ((SimpleUser)user).setUserId("user1");
            ((SimpleUser)user).setUserPassword("test");
            couchbaseEntryManager.merge(user);
        }
        for (SimpleUser user : users) {
            boolean result1 = couchbaseEntryManager.authenticate(user.getDn(), "test");
            boolean result2 = couchbaseEntryManager.authenticate("ou=people,o=jans", SimpleUser.class, user.getUserId(), "test");
            System.out.println("authetication result: " + result1 + ", " + result2 + ", user: " + user.getDn());
        }
        Filter filterAttributes = Filter.createEqualityFilter((String)"jansStatus", (Object)"active");
        List attributes = couchbaseEntryManager.findEntries("ou=attributes,o=jans", SimpleAttribute.class, filterAttributes, SearchScope.SUB, null, null, 10, 0, 0);
        LOG.info("Found attributes: " + attributes.size());
        for (SimpleAttribute attribute : attributes) {
            LOG.info("Attribute with displayName: " + attribute.getCustomAttributes().get(1));
        }
        Filter filterSessions = Filter.createEqualityFilter((String)"jansState", (Object)"authenticated");
        List sessions = couchbaseEntryManager.findEntries("ou=sessions,o=jans", SimpleSession.class, filterSessions, SearchScope.SUB, null, null, 0, 1, 0);
        LOG.info("Found sessions: " + sessions.size());
        List tokens = couchbaseEntryManager.findEntries("ou=tokens,o=jans", SimpleToken.class, null, SearchScope.SUB, new String[]{"code"}, null, 1, 0, 0);
        LOG.info("Found tokens: " + tokens.size());
        try {
            listViewResponse = couchbaseEntryManager.findPagedEntries("ou=people,o=jans", SimpleUser.class, null, new String[]{"uid", "displayName", "status"}, "uid", SortOrder.ASCENDING, 0, 6, 4);
            LOG.info("Found persons: " + listViewResponse.getEntriesCount() + ", total persons: " + listViewResponse.getTotalEntriesCount());
            for (SimpleUser user : listViewResponse.getEntries()) {
                System.out.println(user.getUserId());
            }
        }
        catch (Exception ex) {
            LOG.info("Failed to search", (Throwable)ex);
        }
        try {
            listViewResponse = couchbaseEntryManager.findPagedEntries("ou=people,o=jans", SimpleUser.class, null, new String[]{"uid", "displayName", "status"}, "uid", SortOrder.DESCENDING, 0, 6, 4);
            LOG.info("Found persons: " + listViewResponse.getEntriesCount() + ", total persons: " + listViewResponse.getTotalEntriesCount());
            for (SimpleUser user : listViewResponse.getEntries()) {
                System.out.println(user.getUserId());
            }
        }
        catch (Exception ex) {
            LOG.info("Failed to search", (Throwable)ex);
        }
    }
}

