/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase;

import io.jans.orm.couchbase.CouchbaseEntryManagerSample;
import io.jans.orm.couchbase.impl.CouchbaseEntryManager;
import io.jans.orm.couchbase.model.SimpleUser;
import io.jans.orm.couchbase.operation.impl.CouchbaseConnectionProvider;
import io.jans.orm.model.base.CustomAttribute;
import io.jans.orm.model.base.CustomEntry;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CouchbaseUpdateAttributeSample {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);

    private CouchbaseUpdateAttributeSample() {
    }

    public static void main(String[] args) {
        CouchbaseEntryManagerSample couchbaseEntryManagerSample = new CouchbaseEntryManagerSample();
        CouchbaseEntryManager couchbaseEntryManager = couchbaseEntryManagerSample.createCouchbaseEntryManager();
        String uid = "sample_user_" + System.currentTimeMillis();
        String dn = String.format("inum=%s,ou=people,o=jans", System.currentTimeMillis());
        SimpleUser newUser = new SimpleUser();
        newUser.setDn(dn);
        newUser.setUserId(uid);
        newUser.setUserPassword("test");
        couchbaseEntryManager.persist((Object)newUser);
        SimpleUser user = (SimpleUser)couchbaseEntryManager.find(SimpleUser.class, (Object)dn);
        LOG.info("Found user '{}'", (Object)user);
        CustomEntry customEntry = new CustomEntry();
        customEntry.setDn(user.getDn());
        customEntry.setCustomObjectClasses(new String[]{"jansPerson"});
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        String nowDateString = couchbaseEntryManager.encodeTime(customEntry.getDn(), now);
        CustomAttribute customAttribute = new CustomAttribute("jansLastLogonTime", nowDateString);
        customEntry.getCustomAttributes().add(customAttribute);
        couchbaseEntryManager.merge((Object)customEntry);
        SimpleUser userAfterUpdate = (SimpleUser)couchbaseEntryManager.find(SimpleUser.class, (Object)dn);
        LOG.info("Found user after update '{}'", (Object)userAfterUpdate);
        LOG.info("jansLastLogonTime after update '{}'", userAfterUpdate.getAttribute("jansLastLogonTime"));
    }
}

