/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase;

import io.jans.orm.couchbase.CouchbaseEntryManagerSample;
import io.jans.orm.couchbase.LoggingHelper;
import io.jans.orm.couchbase.impl.CouchbaseEntryManager;
import io.jans.orm.couchbase.model.SimpleUser;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.util.StringHelper;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;

public final class CouchbaseUserSearchSample {
    private static final Logger LOG;
    private static AtomicLong successResult;
    private static AtomicLong failedResult;
    private static AtomicLong errorResult;
    private static AtomicLong totalTime;
    private static AtomicLong activeCount;

    private CouchbaseUserSearchSample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        CouchbaseEntryManagerSample couchbaseEntryManagerSample = new CouchbaseEntryManagerSample();
        final CouchbaseEntryManager couchbaseEntryManager = couchbaseEntryManagerSample.createCouchbaseEntryManager();
        final int countUsers = 1000000;
        int threadCount = 200;
        final int threadIterationCount = 50;
        long totalStart = System.currentTimeMillis();
        try {
            ExecutorService executorService = Executors.newFixedThreadPool(threadCount, CouchbaseUserSearchSample.daemonThreadFactory());
            int i = 0;
            while (i < threadCount) {
                activeCount.incrementAndGet();
                final int count = i++;
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        long start = System.currentTimeMillis();
                        for (int j = 0; j < threadIterationCount; ++j) {
                            long userUid = Math.round(Math.random() * (double)countUsers);
                            String uid = String.format("user%06d", userUid);
                            try {
                                Filter filter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)StringHelper.toLowerCase((String)uid));
                                List foundUsers = couchbaseEntryManager.findEntries("ou=people,o=jans", SimpleUser.class, filter);
                                if (foundUsers.size() > 0) {
                                    successResult.incrementAndGet();
                                    continue;
                                }
                                LOG.warn((Object)("Failed to find user: " + uid));
                                failedResult.incrementAndGet();
                                continue;
                            }
                            catch (Throwable e) {
                                errorResult.incrementAndGet();
                                System.out.println("ERROR !!!, thread: " + count + ", uid: " + uid + ", error:" + e.getMessage());
                                e.printStackTrace();
                            }
                        }
                        long end = System.currentTimeMillis();
                        long duration = end - start;
                        LOG.info((Object)("Thread " + count + " execution time: " + duration));
                        totalTime.addAndGet(duration);
                        activeCount.decrementAndGet();
                    }
                });
            }
            while (activeCount.get() != 0L) {
                Thread.sleep(1000L);
            }
        }
        finally {
            couchbaseEntryManager.destroy();
        }
        long totalEnd = System.currentTimeMillis();
        long duration = totalEnd - totalStart;
        LOG.info((Object)("Total execution time: " + duration + " after execution: " + threadCount * threadIterationCount));
        System.out.println(String.format("successResult: '%d', failedResult: '%d', errorResult: '%d'", successResult.get(), failedResult.get(), errorResult.get()));
    }

    public static ThreadFactory daemonThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        LOG = Logger.getLogger(CouchbaseUserSearchSample.class);
        successResult = new AtomicLong(0L);
        failedResult = new AtomicLong(0L);
        errorResult = new AtomicLong(0L);
        totalTime = new AtomicLong(0L);
        activeCount = new AtomicLong(0L);
    }
}

