/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase.model;

import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.DN;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.JsonObject;
import io.jans.orm.annotation.ObjectClass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@DataEntry
@ObjectClass(value="jansSessId")
public class SimpleSessionState
implements Serializable {
    private static final long serialVersionUID = -237476411915686378L;
    @DN
    private String dn;
    @AttributeName(name="uniqueIdentifier")
    private String id;
    @AttributeName(name="jansLastAccessTime")
    private Date lastUsedAt;
    @AttributeName(name="jansUsrDN")
    private String userDn;
    @AttributeName(name="authnTime")
    private Date authenticationTime;
    @AttributeName(name="jansAuthSessionState")
    private Boolean permissionGranted;
    @AttributeName(name="jansAsJwt")
    private Boolean isJwt = false;
    @AttributeName(name="jansJwt")
    private String jwt;
    @JsonObject
    @AttributeName(name="jansSessAttr")
    private Map<String, String> sessionAttributes;
    @Transient
    private transient boolean persisted;

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getJwt() {
        return this.jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public Boolean getIsJwt() {
        return this.isJwt;
    }

    public void setIsJwt(Boolean isJwt) {
        this.isJwt = isJwt;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getLastUsedAt() {
        return this.lastUsedAt != null ? new Date(this.lastUsedAt.getTime()) : null;
    }

    public void setLastUsedAt(Date lastUsedAt) {
        this.lastUsedAt = lastUsedAt != null ? new Date(lastUsedAt.getTime()) : null;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn != null ? userDn : "";
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime != null ? new Date(this.authenticationTime.getTime()) : null;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime != null ? new Date(authenticationTime.getTime()) : null;
    }

    public Boolean getPermissionGranted() {
        return this.permissionGranted;
    }

    public void setPermissionGranted(Boolean permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    public Map<String, String> getSessionAttributes() {
        if (this.sessionAttributes == null) {
            this.sessionAttributes = new HashMap<String, String>();
        }
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSessionState id1 = (SimpleSessionState)o;
        return !(this.id == null ? id1.id != null : !this.id.equals(id1.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionState");
        sb.append(", dn='").append(this.dn).append('\'');
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", isJwt=").append(this.isJwt);
        sb.append(", lastUsedAt=").append(this.lastUsedAt);
        sb.append(", userDn='").append(this.userDn).append('\'');
        sb.append(", authenticationTime=").append(this.authenticationTime);
        sb.append(", permissionGranted=").append(this.permissionGranted);
        sb.append(", sessionAttributes=").append(this.sessionAttributes);
        sb.append(", persisted=").append(this.persisted);
        sb.append('}');
        return sb.toString();
    }
}

