/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase.impl;

import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.client.java.env.ClusterEnvironment;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.couchbase.impl.CouchbaseEntryManager;
import io.jans.orm.couchbase.operation.impl.CouchbaseConnectionProvider;
import io.jans.orm.couchbase.operation.impl.CouchbaseOperationServiceImpl;
import io.jans.orm.exception.operation.ConfigurationException;
import io.jans.orm.service.BaseFactoryService;
import io.jans.orm.util.PropertiesHelper;
import io.jans.orm.util.StringHelper;
import io.jans.orm.util.init.Initializable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import java.nio.file.FileSystems;
import java.time.Duration;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CouchbaseEntryManagerFactory
extends Initializable
implements PersistenceEntryManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseEntryManagerFactory.class);
    public static final String PERSISTENCE_TYPE = PersistenceEntryManager.PERSITENCE_TYPES.couchbase.name();
    public static final String PROPERTIES_FILE = "jans-couchbase%s.properties";
    private ClusterEnvironment clusterEnvironment;
    private Properties couchbaseConnectionProperties;

    @PostConstruct
    public void create() {
    }

    @PreDestroy
    public void destroy() {
        if (this.clusterEnvironment != null) {
            this.clusterEnvironment.shutdown();
            this.resetInitialized();
            LOG.info("Couchbase environment was destroyed successfully");
        }
    }

    protected void initInternal() {
        String mutationTokensEnabledString;
        String queryTimeoutString;
        String kvTimeoutString;
        String connectDnsUseLookupString;
        ClusterEnvironment.Builder clusterEnvironmentBuilder = ClusterEnvironment.builder();
        boolean useSSL = Boolean.valueOf(this.couchbaseConnectionProperties.getProperty("ssl.trustStore.enable"));
        if (useSSL) {
            String sslTrustStoreFile = this.couchbaseConnectionProperties.getProperty("ssl.trustStore.file");
            String sslTrustStorePin = this.couchbaseConnectionProperties.getProperty("ssl.trustStore.pin");
            Optional<String> sslTrustStoreType = Optional.ofNullable(this.couchbaseConnectionProperties.getProperty("ssl.trustStore.type"));
            SecurityConfig.Builder securityConfigBuilder = clusterEnvironmentBuilder.securityConfig();
            boolean enableTLS = Boolean.valueOf(this.couchbaseConnectionProperties.getProperty("tls.enable"));
            if (enableTLS) {
                securityConfigBuilder.enableTls(enableTLS);
            }
            securityConfigBuilder.trustStore(FileSystems.getDefault().getPath(sslTrustStoreFile, new String[0]), sslTrustStorePin, sslTrustStoreType);
            LOG.info("Configuring builder to enable SSL support");
        } else {
            clusterEnvironmentBuilder.securityConfig().enableTls(false);
            LOG.info("Configuring builder to disable SSL support");
        }
        String connectTimeoutString = this.couchbaseConnectionProperties.getProperty("connection.connect-timeout");
        if (StringHelper.isNotEmpty((String)connectTimeoutString)) {
            int connectTimeout = Integer.valueOf(connectTimeoutString);
            clusterEnvironmentBuilder.timeoutConfig().connectTimeout(Duration.ofMillis(connectTimeout));
            LOG.info("Configuring builder to override connectTimeout from properties");
        }
        if (StringHelper.isNotEmpty((String)(connectDnsUseLookupString = this.couchbaseConnectionProperties.getProperty("connection.dns.use-lookup")))) {
            boolean connectDnsUseLookup = Boolean.valueOf(connectDnsUseLookupString);
            clusterEnvironmentBuilder.ioConfig().enableDnsSrv(connectDnsUseLookup);
            LOG.info("Configuring builder to override enableDnsSrv from properties");
        }
        if (StringHelper.isNotEmpty((String)(kvTimeoutString = this.couchbaseConnectionProperties.getProperty("connection.kv-timeout")))) {
            int kvTimeout = Integer.valueOf(kvTimeoutString);
            clusterEnvironmentBuilder.timeoutConfig().kvTimeout(Duration.ofMillis(kvTimeout));
            LOG.info("Configuring builder to override kvTimeout from properties");
        }
        if (StringHelper.isNotEmpty((String)(queryTimeoutString = this.couchbaseConnectionProperties.getProperty("connection.query-timeout")))) {
            int queryTimeout = Integer.valueOf(queryTimeoutString);
            clusterEnvironmentBuilder.timeoutConfig().queryTimeout(Duration.ofMillis(queryTimeout));
            LOG.info("Configuring builder to override queryTimeout from properties");
        }
        if (StringHelper.isNotEmpty((String)(mutationTokensEnabledString = this.couchbaseConnectionProperties.getProperty("connection.mutation-tokens-enabled")))) {
            boolean mutationTokensEnabled = Boolean.valueOf(mutationTokensEnabledString);
            clusterEnvironmentBuilder.ioConfig().enableMutationTokens(mutationTokensEnabled);
            LOG.info("Configuring builder to override mutationTokensEnabled from properties");
        }
        this.clusterEnvironment = clusterEnvironmentBuilder.build();
    }

    public String getPersistenceType() {
        return PERSISTENCE_TYPE;
    }

    public HashMap<String, String> getConfigurationFileNames(String alias) {
        Object usedAlias = StringHelper.isEmpty((String)alias) ? "" : "." + alias;
        HashMap<String, String> confs = new HashMap<String, String>();
        String confFileName = String.format(PROPERTIES_FILE, usedAlias);
        confs.put(PERSISTENCE_TYPE + (String)usedAlias, confFileName);
        return confs;
    }

    public ClusterEnvironment getClusterEnvironment() {
        return this.clusterEnvironment;
    }

    public CouchbaseEntryManager createEntryManager(Properties conf) {
        Properties entryManagerConf = PropertiesHelper.filterProperties((Properties)conf, (String)"#");
        if (this.couchbaseConnectionProperties == null) {
            this.couchbaseConnectionProperties = entryManagerConf;
        }
        this.init();
        if (!this.isInitialized()) {
            throw new ConfigurationException("Failed to create Couchbase environment!");
        }
        CouchbaseConnectionProvider connectionProvider = new CouchbaseConnectionProvider(entryManagerConf, this.clusterEnvironment);
        connectionProvider.create();
        if (!connectionProvider.isCreated()) {
            throw new ConfigurationException(String.format("Failed to create Couchbase connection pool! Result code: '%s'", connectionProvider.getCreationResultCode()));
        }
        LOG.debug("Created connectionProvider '{}' with code '{}'", (Object)connectionProvider, (Object)connectionProvider.getCreationResultCode());
        CouchbaseEntryManager couchbaseEntryManager = new CouchbaseEntryManager(new CouchbaseOperationServiceImpl(entryManagerConf, connectionProvider));
        LOG.info("Created CouchbaseEntryManager: {}", (Object)couchbaseEntryManager.getOperationService());
        return couchbaseEntryManager;
    }

    public void initStandalone(BaseFactoryService persistanceFactoryService) {
        ClusterEnvironment.Builder clusterEnvironmentBuilder = ClusterEnvironment.builder();
        clusterEnvironmentBuilder.ioConfig().enableMutationTokens(true).build();
        this.clusterEnvironment = clusterEnvironmentBuilder.build();
    }
}

