/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase.impl.test;

import com.couchbase.client.java.json.JsonObject;
import io.jans.orm.couchbase.impl.CouchbaseFilterConverter;
import io.jans.orm.couchbase.model.ConvertedExpression;
import io.jans.orm.couchbase.operation.CouchbaseOperationService;
import io.jans.orm.couchbase.operation.impl.CouchbaseOperationServiceImpl;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.search.filter.FilterProcessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CouchbaseFilterConverterCheckExcludeFilterTest {
    private CouchbaseOperationService couchbaseOperationService;
    private CouchbaseFilterConverter simpleConverter;
    private FilterProcessor filterProcessor;

    @BeforeClass
    public void init() {
        this.couchbaseOperationService = new CouchbaseOperationServiceImpl();
        this.simpleConverter = new CouchbaseFilterConverter(this.couchbaseOperationService);
        this.filterProcessor = new FilterProcessor();
    }

    @Test
    public void checkObjectClassExcludeFilter() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test");
        Filter filterEq2 = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)"test");
        Filter filterEq3 = Filter.createEqualityFilter((String)"objectClass", (Object)"jansPerson");
        Filter filterEq4 = Filter.createEqualityFilter((String)"added", (Object)CouchbaseFilterConverterCheckExcludeFilterTest.getUtcDateFromMillis(1608130698398L)).multiValued();
        Filter andFilter = Filter.createANDFilter((Filter[])new Filter[]{filterEq1, filterEq2, filterEq3, filterEq4});
        Filter orFilter = Filter.createANDFilter((Filter[])new Filter[]{filterEq1, filterEq2, filterEq3, andFilter, filterEq4});
        Filter filter1 = Filter.createANDFilter((Filter[])new Filter[]{filterEq3, orFilter});
        ConvertedExpression expression1 = this.simpleConverter.convertToCouchbaseFilter(filter1, null, null);
        String query1 = this.toSelectSQL(expression1);
        Assert.assertEquals((String)query1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ( ( ( objectClass = \"jansPerson\" ) OR ( \"jansPerson\" IN objectClass ) ) AND ( ( ( uid = \"test\" ) OR ( \"test\" IN uid ) ) AND LOWER( uid ) = \"test\" AND ( ( objectClass = \"jansPerson\" ) OR ( \"jansPerson\" IN objectClass ) ) AND ( ( ( uid = \"test\" ) OR ( \"test\" IN uid ) ) AND LOWER( uid ) = \"test\" AND ( ( objectClass = \"jansPerson\" ) OR ( \"jansPerson\" IN objectClass ) ) AND ANY added_ IN added SATISFIES added_ = \"2020-12-16T14:58:18.398Z\" END ) AND ANY added_ IN added SATISFIES added_ = \"2020-12-16T14:58:18.398Z\" END ) )");
        Filter filter2 = this.filterProcessor.excludeFilter(filter1, new Filter[]{filterEq3});
        ConvertedExpression expression2 = this.simpleConverter.convertToCouchbaseFilter(filter2, null, null);
        String query2 = this.toSelectSQL(expression2);
        Assert.assertEquals((String)query2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ( ( ( ( uid = \"test\" ) OR ( \"test\" IN uid ) ) AND LOWER( uid ) = \"test\" AND ( ( ( uid = \"test\" ) OR ( \"test\" IN uid ) ) AND LOWER( uid ) = \"test\" AND ANY added_ IN added SATISFIES added_ = \"2020-12-16T14:58:18.398Z\" END ) AND ANY added_ IN added SATISFIES added_ = \"2020-12-16T14:58:18.398Z\" END ) )");
        Filter filter3 = this.filterProcessor.excludeFilter(filter1, new Filter[]{Filter.createEqualityFilter((String)"objectClass", null)});
        ConvertedExpression expression3 = this.simpleConverter.convertToCouchbaseFilter(filter3, null, null);
        String query3 = this.toSelectSQL(expression3);
        Assert.assertEquals((String)query3, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ( ( ( ( uid = \"test\" ) OR ( \"test\" IN uid ) ) AND LOWER( uid ) = \"test\" AND ( ( ( uid = \"test\" ) OR ( \"test\" IN uid ) ) AND LOWER( uid ) = \"test\" AND ANY added_ IN added SATISFIES added_ = \"2020-12-16T14:58:18.398Z\" END ) AND ANY added_ IN added SATISFIES added_ = \"2020-12-16T14:58:18.398Z\" END ) )");
    }

    private String toSelectSQL(ConvertedExpression convertedExpression) {
        String select = String.format("SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE %s", convertedExpression.expression());
        JsonObject params = convertedExpression.getQueryParameters();
        for (String name : params.getNames()) {
            Object value;
            Object replaceValue = value = params.get(name);
            if (value instanceof String) {
                replaceValue = "\"" + value + "\"";
            }
            String searchName = "\\$" + name;
            int subIndex = select.indexOf("%$" + name + "%");
            if (subIndex != -1) {
                searchName = "%" + searchName + "%";
                replaceValue = "\"%" + value + "%\"";
            }
            select = select.replaceAll(searchName, replaceValue.toString());
        }
        select = select.replaceAll("\"\"%", "%").replaceAll("%\"\"", "%");
        return select;
    }

    private static Date getUtcDateFromMillis(long millis) {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(millis);
        calendar.set(15, TimeZone.getTimeZone("UTC").getRawOffset());
        Date date = calendar.getTime();
        return date;
    }
}

