/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase.impl.test;

import com.couchbase.client.java.json.JsonObject;
import io.jans.orm.couchbase.impl.CouchbaseFilterConverter;
import io.jans.orm.couchbase.model.ConvertedExpression;
import io.jans.orm.couchbase.operation.CouchbaseOperationService;
import io.jans.orm.couchbase.operation.impl.CouchbaseOperationServiceImpl;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.search.filter.Filter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CouchbaseFilterConverterTest {
    private CouchbaseFilterConverter simpleConverter;
    private CouchbaseOperationService couchbaseOperationService;

    @BeforeClass
    public void init() {
        this.couchbaseOperationService = new CouchbaseOperationServiceImpl();
        this.simpleConverter = new CouchbaseFilterConverter(this.couchbaseOperationService);
    }

    @Test
    public void checkEqFilters() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test");
        ConvertedExpression expressionEq1 = this.simpleConverter.convertToCouchbaseFilter(filterEq1, null, null);
        String queryEq1 = this.toSelectSQL(expressionEq1);
        Assert.assertEquals((String)expressionEq1.expression(), (String)"( ( uid = $uid ) OR ( $uid IN uid ) )");
        Assert.assertEquals((String)queryEq1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ( ( uid = \"test\" ) OR ( \"test\" IN uid ) )");
        Filter filterEq2 = Filter.createEqualityFilter((String)"age", (Object)23);
        ConvertedExpression expressionEq2 = this.simpleConverter.convertToCouchbaseFilter(filterEq2, null, null);
        String queryEq2 = this.toSelectSQL(expressionEq2);
        Assert.assertEquals((String)expressionEq2.expression(), (String)"( ( age = $age ) OR ( $age IN age ) )");
        Assert.assertEquals((String)queryEq2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ( ( age = 23 ) OR ( 23 IN age ) )");
        Filter filterEq3 = Filter.createEqualityFilter((String)"age", (Object)23L);
        ConvertedExpression expressionEq3 = this.simpleConverter.convertToCouchbaseFilter(filterEq3, null, null);
        String queryEq3 = this.toSelectSQL(expressionEq3);
        Assert.assertEquals((String)expressionEq3.expression(), (String)"( ( age = $age ) OR ( $age IN age ) )");
        Assert.assertEquals((String)queryEq3, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ( ( age = 23 ) OR ( 23 IN age ) )");
        Filter filterEq4 = Filter.createEqualityFilter((String)"added", (Object)CouchbaseFilterConverterTest.getUtcDateFromMillis(1608130698398L));
        ConvertedExpression expressionEq4 = this.simpleConverter.convertToCouchbaseFilter(filterEq4, null, null);
        String queryEq4 = this.toSelectSQL(expressionEq4);
        Assert.assertEquals((String)expressionEq4.expression(), (String)"( ( added = $added ) OR ( $added IN added ) )");
        Assert.assertEquals((String)queryEq4, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ( ( added = \"2020-12-16T14:58:18.398Z\" ) OR ( \"2020-12-16T14:58:18.398Z\" IN added ) )");
    }

    @Test
    public void checkMultivaluedEqFilters() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test").multiValued();
        ConvertedExpression expressionEq1 = this.simpleConverter.convertToCouchbaseFilter(filterEq1, null, null);
        String queryEq1 = this.toSelectSQL(expressionEq1);
        Assert.assertEquals((String)expressionEq1.expression(), (String)"ANY uid_ IN uid SATISFIES uid_ = $uid END");
        Assert.assertEquals((String)queryEq1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES uid_ = \"test\" END");
        Filter filterEq2 = Filter.createEqualityFilter((String)"age", (Object)23).multiValued();
        ConvertedExpression expressionEq2 = this.simpleConverter.convertToCouchbaseFilter(filterEq2, null, null);
        String queryEq2 = this.toSelectSQL(expressionEq2);
        Assert.assertEquals((String)expressionEq2.expression(), (String)"ANY age_ IN age SATISFIES age_ = $age END");
        Assert.assertEquals((String)queryEq2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY age_ IN age SATISFIES age_ = 23 END");
        Filter filterEq3 = Filter.createEqualityFilter((String)"age", (Object)23L).multiValued();
        ConvertedExpression expressionEq3 = this.simpleConverter.convertToCouchbaseFilter(filterEq3, null, null);
        String queryEq3 = this.toSelectSQL(expressionEq3);
        Assert.assertEquals((String)expressionEq3.expression(), (String)"ANY age_ IN age SATISFIES age_ = $age END");
        Assert.assertEquals((String)queryEq3, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY age_ IN age SATISFIES age_ = 23 END");
        Filter filterEq4 = Filter.createEqualityFilter((String)"added", (Object)CouchbaseFilterConverterTest.getUtcDateFromMillis(1608130698398L)).multiValued();
        ConvertedExpression expressionEq4 = this.simpleConverter.convertToCouchbaseFilter(filterEq4, null, null);
        String queryEq4 = this.toSelectSQL(expressionEq4);
        Assert.assertEquals((String)expressionEq4.expression(), (String)"ANY added_ IN added SATISFIES added_ = $added END");
        Assert.assertEquals((String)queryEq4, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY added_ IN added SATISFIES added_ = \"2020-12-16T14:58:18.398Z\" END");
    }

    @Test
    public void checkSinglevaluedEqFilters() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test").multiValued(Boolean.valueOf(false));
        ConvertedExpression expressionEq1 = this.simpleConverter.convertToCouchbaseFilter(filterEq1, null, null);
        String queryEq1 = this.toSelectSQL(expressionEq1);
        Assert.assertEquals((String)expressionEq1.expression(), (String)"uid = $uid");
        Assert.assertEquals((String)queryEq1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE uid = \"test\"");
        Filter filterEq2 = Filter.createEqualityFilter((String)"age", (Object)23).multiValued(Boolean.valueOf(false));
        ConvertedExpression expressionEq2 = this.simpleConverter.convertToCouchbaseFilter(filterEq2, null, null);
        String queryEq2 = this.toSelectSQL(expressionEq2);
        Assert.assertEquals((String)expressionEq2.expression(), (String)"age = $age");
        Assert.assertEquals((String)queryEq2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE age = 23");
        Filter filterEq3 = Filter.createEqualityFilter((String)"age", (Object)23L).multiValued(Boolean.valueOf(false));
        ConvertedExpression expressionEq3 = this.simpleConverter.convertToCouchbaseFilter(filterEq3, null, null);
        String queryEq3 = this.toSelectSQL(expressionEq3);
        Assert.assertEquals((String)expressionEq3.expression(), (String)"age = $age");
        Assert.assertEquals((String)queryEq3, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE age = 23");
        Filter filterEq4 = Filter.createEqualityFilter((String)"added", (Object)CouchbaseFilterConverterTest.getUtcDateFromMillis(1608130698398L)).multiValued(Boolean.valueOf(false));
        ConvertedExpression expressionEq4 = this.simpleConverter.convertToCouchbaseFilter(filterEq4, null, null);
        String queryEq4 = this.toSelectSQL(expressionEq4);
        Assert.assertEquals((String)expressionEq4.expression(), (String)"added = $added");
        Assert.assertEquals((String)queryEq4, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE added = \"2020-12-16T14:58:18.398Z\"");
    }

    @Test
    public void checkLeFilters() throws SearchException {
        Filter filterLe1 = Filter.createLessOrEqualFilter((String)"uid", (Object)"test");
        ConvertedExpression expressionLe1 = this.simpleConverter.convertToCouchbaseFilter(filterLe1, null, null);
        String queryLe1 = this.toSelectSQL(expressionLe1);
        Assert.assertEquals((String)expressionLe1.expression(), (String)"uid <= $uid");
        Assert.assertEquals((String)queryLe1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE uid <= \"test\"");
        Filter filterLe2 = Filter.createLessOrEqualFilter((String)"age", (Object)23);
        ConvertedExpression expressionLe2 = this.simpleConverter.convertToCouchbaseFilter(filterLe2, null, null);
        String queryLe2 = this.toSelectSQL(expressionLe2);
        Assert.assertEquals((String)expressionLe2.expression(), (String)"age <= $age");
        Assert.assertEquals((String)queryLe2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE age <= 23");
        Filter filterLe3 = Filter.createLessOrEqualFilter((String)"age", (Object)23L);
        ConvertedExpression expressionLe3 = this.simpleConverter.convertToCouchbaseFilter(filterLe3, null, null);
        String queryLe3 = this.toSelectSQL(expressionLe3);
        Assert.assertEquals((String)expressionLe3.expression(), (String)"age <= $age");
        Assert.assertEquals((String)queryLe3, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE age <= 23");
        Filter filterLe4 = Filter.createLessOrEqualFilter((String)"added", (Object)CouchbaseFilterConverterTest.getUtcDateFromMillis(1608130698398L));
        ConvertedExpression expressionLe4 = this.simpleConverter.convertToCouchbaseFilter(filterLe4, null, null);
        String queryLe4 = this.toSelectSQL(expressionLe4);
        Assert.assertEquals((String)expressionLe4.expression(), (String)"added <= $added");
        Assert.assertEquals((String)queryLe4, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE added <= \"2020-12-16T14:58:18.398Z\"");
    }

    @Test
    public void checkMultivaluedLeFilters() throws SearchException {
        Filter filterLe1 = Filter.createLessOrEqualFilter((String)"uid", (Object)"test").multiValued();
        ConvertedExpression expressionLe1 = this.simpleConverter.convertToCouchbaseFilter(filterLe1, null, null);
        String queryLe1 = this.toSelectSQL(expressionLe1);
        Assert.assertEquals((String)expressionLe1.expression(), (String)"ANY uid_ IN uid SATISFIES uid_ <= $uid END");
        Assert.assertEquals((String)queryLe1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES uid_ <= \"test\" END");
        Filter filterLe2 = Filter.createLessOrEqualFilter((String)"age", (Object)23).multiValued();
        ConvertedExpression expressionLe2 = this.simpleConverter.convertToCouchbaseFilter(filterLe2, null, null);
        String queryLe2 = this.toSelectSQL(expressionLe2);
        Assert.assertEquals((String)expressionLe2.expression(), (String)"ANY age_ IN age SATISFIES age_ <= $age END");
        Assert.assertEquals((String)queryLe2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY age_ IN age SATISFIES age_ <= 23 END");
        Filter filterLe3 = Filter.createLessOrEqualFilter((String)"age", (Object)23L).multiValued();
        ConvertedExpression expressionLe3 = this.simpleConverter.convertToCouchbaseFilter(filterLe3, null, null);
        String queryLe3 = this.toSelectSQL(expressionLe3);
        Assert.assertEquals((String)expressionLe3.expression(), (String)"ANY age_ IN age SATISFIES age_ <= $age END");
        Assert.assertEquals((String)queryLe3, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY age_ IN age SATISFIES age_ <= 23 END");
        Filter filterLe4 = Filter.createLessOrEqualFilter((String)"added", (Object)CouchbaseFilterConverterTest.getUtcDateFromMillis(1608130698398L)).multiValued();
        ConvertedExpression expressionLe4 = this.simpleConverter.convertToCouchbaseFilter(filterLe4, null, null);
        String queryLe4 = this.toSelectSQL(expressionLe4);
        Assert.assertEquals((String)expressionLe4.expression(), (String)"ANY added_ IN added SATISFIES added_ <= $added END");
        Assert.assertEquals((String)queryLe4, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY added_ IN added SATISFIES added_ <= \"2020-12-16T14:58:18.398Z\" END");
        Filter filterLe5 = Filter.createLessOrEqualFilter((String)"added", (Object)CouchbaseFilterConverterTest.getUtcDateFromMillis(1608130698398L)).multiValued(3);
        ConvertedExpression expressionLe5 = this.simpleConverter.convertToCouchbaseFilter(filterLe5, null, null);
        String queryLe5 = this.toSelectSQL(expressionLe5);
        Assert.assertEquals((String)expressionLe5.expression(), (String)"ANY added_ IN added SATISFIES added_ <= $added END");
        Assert.assertEquals((String)queryLe5, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY added_ IN added SATISFIES added_ <= \"2020-12-16T14:58:18.398Z\" END");
    }

    @Test
    public void checkGeFilters() throws SearchException {
        Filter filterGe1 = Filter.createGreaterOrEqualFilter((String)"uid", (Object)"test");
        ConvertedExpression expressionGe1 = this.simpleConverter.convertToCouchbaseFilter(filterGe1, null, null);
        String queryGe1 = this.toSelectSQL(expressionGe1);
        Assert.assertEquals((String)expressionGe1.expression(), (String)"uid >= $uid");
        Assert.assertEquals((String)queryGe1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE uid >= \"test\"");
        Filter filterGe2 = Filter.createGreaterOrEqualFilter((String)"age", (Object)23);
        ConvertedExpression expressionGe2 = this.simpleConverter.convertToCouchbaseFilter(filterGe2, null, null);
        String queryGe2 = this.toSelectSQL(expressionGe2);
        Assert.assertEquals((String)expressionGe2.expression(), (String)"age >= $age");
        Assert.assertEquals((String)queryGe2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE age >= 23");
        Filter filterGe3 = Filter.createGreaterOrEqualFilter((String)"age", (Object)23L);
        ConvertedExpression expressionGe3 = this.simpleConverter.convertToCouchbaseFilter(filterGe3, null, null);
        String queryGe3 = this.toSelectSQL(expressionGe3);
        Assert.assertEquals((String)expressionGe3.expression(), (String)"age >= $age");
        Assert.assertEquals((String)queryGe3, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE age >= 23");
        Filter filterGe4 = Filter.createGreaterOrEqualFilter((String)"added", (Object)CouchbaseFilterConverterTest.getUtcDateFromMillis(1608130698398L));
        ConvertedExpression expressionGe4 = this.simpleConverter.convertToCouchbaseFilter(filterGe4, null, null);
        String queryGe4 = this.toSelectSQL(expressionGe4);
        Assert.assertEquals((String)expressionGe4.expression(), (String)"added >= $added");
        Assert.assertEquals((String)queryGe4, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE added >= \"2020-12-16T14:58:18.398Z\"");
    }

    @Test
    public void checkMultivaluedGeFilters() throws SearchException {
        Filter filterGe1 = Filter.createGreaterOrEqualFilter((String)"uid", (Object)"test").multiValued();
        ConvertedExpression expressionGe1 = this.simpleConverter.convertToCouchbaseFilter(filterGe1, null, null);
        String queryGe1 = this.toSelectSQL(expressionGe1);
        Assert.assertEquals((String)expressionGe1.expression(), (String)"ANY uid_ IN uid SATISFIES uid_ >= $uid END");
        Assert.assertEquals((String)queryGe1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES uid_ >= \"test\" END");
        Filter filterGe2 = Filter.createGreaterOrEqualFilter((String)"age", (Object)23).multiValued();
        ConvertedExpression expressionGe2 = this.simpleConverter.convertToCouchbaseFilter(filterGe2, null, null);
        String queryGe2 = this.toSelectSQL(expressionGe2);
        Assert.assertEquals((String)expressionGe2.expression(), (String)"ANY age_ IN age SATISFIES age_ >= $age END");
        Assert.assertEquals((String)queryGe2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY age_ IN age SATISFIES age_ >= 23 END");
        Filter filterGe3 = Filter.createGreaterOrEqualFilter((String)"age", (Object)23L).multiValued();
        ConvertedExpression expressionGe3 = this.simpleConverter.convertToCouchbaseFilter(filterGe3, null, null);
        String queryGe3 = this.toSelectSQL(expressionGe3);
        Assert.assertEquals((String)expressionGe3.expression(), (String)"ANY age_ IN age SATISFIES age_ >= $age END");
        Assert.assertEquals((String)queryGe3, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY age_ IN age SATISFIES age_ >= 23 END");
        Filter filterGe4 = Filter.createGreaterOrEqualFilter((String)"added", (Object)CouchbaseFilterConverterTest.getUtcDateFromMillis(1608130698398L)).multiValued();
        ConvertedExpression expressionGe4 = this.simpleConverter.convertToCouchbaseFilter(filterGe4, null, null);
        String queryGe4 = this.toSelectSQL(expressionGe4);
        Assert.assertEquals((String)expressionGe4.expression(), (String)"ANY added_ IN added SATISFIES added_ >= $added END");
        Assert.assertEquals((String)queryGe4, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY added_ IN added SATISFIES added_ >= \"2020-12-16T14:58:18.398Z\" END");
        Filter filterGe5 = Filter.createGreaterOrEqualFilter((String)"added", (Object)CouchbaseFilterConverterTest.getUtcDateFromMillis(1608130698398L)).multiValued(3);
        ConvertedExpression expressionGe5 = this.simpleConverter.convertToCouchbaseFilter(filterGe5, null, null);
        String queryGe5 = this.toSelectSQL(expressionGe5);
        Assert.assertEquals((String)expressionGe5.expression(), (String)"ANY added_ IN added SATISFIES added_ >= $added END");
        Assert.assertEquals((String)queryGe5, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY added_ IN added SATISFIES added_ >= \"2020-12-16T14:58:18.398Z\" END");
    }

    @Test
    public void checkPresenceFilters() throws SearchException {
        Filter filterPresence = Filter.createPresenceFilter((String)"uid");
        ConvertedExpression expressionPresence = this.simpleConverter.convertToCouchbaseFilter(filterPresence, null, null);
        String queryPresence = this.toSelectSQL(expressionPresence);
        Assert.assertEquals((String)expressionPresence.expression(), (String)"uid IS NOT MISSING");
        Assert.assertEquals((String)queryPresence, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE uid IS NOT MISSING");
    }

    @Test
    public void checkMultivaluedPresenceFilters() throws SearchException {
        Filter filterPresence1 = Filter.createPresenceFilter((String)"uid").multiValued();
        ConvertedExpression expressionPresence1 = this.simpleConverter.convertToCouchbaseFilter(filterPresence1, null, null);
        String queryPresence1 = this.toSelectSQL(expressionPresence1);
        Assert.assertEquals((String)expressionPresence1.expression(), (String)"ANY uid_ IN uid SATISFIES uid_ IS NOT MISSING END");
        Assert.assertEquals((String)queryPresence1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES uid_ IS NOT MISSING END");
        Filter filterPresence2 = Filter.createPresenceFilter((String)"uid").multiValued(3);
        ConvertedExpression expressionPresence2 = this.simpleConverter.convertToCouchbaseFilter(filterPresence2, null, null);
        String queryPresence2 = this.toSelectSQL(expressionPresence2);
        Assert.assertEquals((String)expressionPresence2.expression(), (String)"ANY uid_ IN uid SATISFIES uid_ IS NOT MISSING END");
        Assert.assertEquals((String)queryPresence2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES uid_ IS NOT MISSING END");
    }

    @Test
    public void checkSubFilters() throws SearchException {
        Filter filterSub1 = Filter.createSubstringFilter((String)"uid", null, (String[])new String[]{"test"}, null);
        ConvertedExpression expressionSub1 = this.simpleConverter.convertToCouchbaseFilter(filterSub1, null, null);
        String querySub1 = this.toSelectSQL(expressionSub1);
        Assert.assertEquals((String)expressionSub1.expression(), (String)"uid LIKE $uid_any");
        Assert.assertEquals((String)querySub1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE uid LIKE \"%test%\"");
        Filter filterSub2 = Filter.createSubstringFilter((String)"uid", (String)"a", (String[])new String[]{"test"}, null);
        ConvertedExpression expressionSub2 = this.simpleConverter.convertToCouchbaseFilter(filterSub2, null, null);
        String querySub2 = this.toSelectSQL(expressionSub2);
        Assert.assertEquals((String)expressionSub2.expression(), (String)"uid LIKE $uid_i$uid_any");
        Assert.assertEquals((String)querySub2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE uid LIKE \"a%%test%\"");
        Filter filterSub3 = Filter.createSubstringFilter((String)"uid", null, (String[])new String[]{"test"}, (String)"z");
        ConvertedExpression expressionSub3 = this.simpleConverter.convertToCouchbaseFilter(filterSub3, null, null);
        String querySub3 = this.toSelectSQL(expressionSub3);
        Assert.assertEquals((String)expressionSub3.expression(), (String)"uid LIKE $uid_any$uid_f");
        Assert.assertEquals((String)querySub3, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE uid LIKE \"%test%%z\"");
    }

    @Test
    public void checkMultivaluedSubFilters() throws SearchException {
        Filter filterSub1 = Filter.createSubstringFilter((String)"uid", null, (String[])new String[]{"test"}, null).multiValued();
        ConvertedExpression expressionSub1 = this.simpleConverter.convertToCouchbaseFilter(filterSub1, null, null);
        String querySub1 = this.toSelectSQL(expressionSub1);
        Assert.assertEquals((String)expressionSub1.expression(), (String)"ANY uid_ IN uid SATISFIES uid_ LIKE $uid_any END");
        Assert.assertEquals((String)querySub1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES uid_ LIKE \"%test%\" END");
        Filter filterSub2 = Filter.createSubstringFilter((String)"uid", (String)"a", (String[])new String[]{"test"}, null).multiValued();
        ConvertedExpression expressionSub2 = this.simpleConverter.convertToCouchbaseFilter(filterSub2, null, null);
        String querySub2 = this.toSelectSQL(expressionSub2);
        Assert.assertEquals((String)expressionSub2.expression(), (String)"ANY uid_ IN uid SATISFIES uid_ LIKE $uid_i$uid_any END");
        Assert.assertEquals((String)querySub2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES uid_ LIKE \"a%%test%\" END");
        Filter filterSub3 = Filter.createSubstringFilter((String)"uid", null, (String[])new String[]{"test"}, (String)"z").multiValued();
        ConvertedExpression expressionSub3 = this.simpleConverter.convertToCouchbaseFilter(filterSub3, null, null);
        String querySub3 = this.toSelectSQL(expressionSub3);
        Assert.assertEquals((String)expressionSub3.expression(), (String)"ANY uid_ IN uid SATISFIES uid_ LIKE $uid_any$uid_f END");
        Assert.assertEquals((String)querySub3, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES uid_ LIKE \"%test%%z\" END");
        Filter filterSub4 = Filter.createSubstringFilter((String)"uid", null, (String[])new String[]{"test"}, (String)"z").multiValued(3);
        ConvertedExpression expressionSub4 = this.simpleConverter.convertToCouchbaseFilter(filterSub4, null, null);
        String querySub4 = this.toSelectSQL(expressionSub4);
        Assert.assertEquals((String)expressionSub4.expression(), (String)"ANY uid_ IN uid SATISFIES uid_ LIKE $uid_any$uid_f END");
        Assert.assertEquals((String)querySub4, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES uid_ LIKE \"%test%%z\" END");
    }

    @Test
    public void checkMultivaluedSubWithLowerFilters() throws SearchException {
        Filter filterSub1 = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"uid"), null, (String[])new String[]{"test"}, null).multiValued();
        ConvertedExpression expressionSub1 = this.simpleConverter.convertToCouchbaseFilter(filterSub1, null, null);
        String querySub1 = this.toSelectSQL(expressionSub1);
        Assert.assertEquals((String)expressionSub1.expression(), (String)"ANY uid_ IN uid SATISFIES LOWER( uid_ ) LIKE $uid_any END");
        Assert.assertEquals((String)querySub1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES LOWER( uid_ ) LIKE \"%test%\" END");
        Filter filterSub2 = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (String)"a", (String[])new String[]{"test"}, null).multiValued();
        ConvertedExpression expressionSub2 = this.simpleConverter.convertToCouchbaseFilter(filterSub2, null, null);
        String querySub2 = this.toSelectSQL(expressionSub2);
        Assert.assertEquals((String)expressionSub1.expression(), (String)"ANY uid_ IN uid SATISFIES LOWER( uid_ ) LIKE $uid_any END");
        Assert.assertEquals((String)querySub2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES LOWER( uid_ ) LIKE \"a%%test%\" END");
        Filter filterSub3 = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"uid"), null, (String[])new String[]{"test"}, (String)"z").multiValued();
        ConvertedExpression expressionSub3 = this.simpleConverter.convertToCouchbaseFilter(filterSub3, null, null);
        String querySub3 = this.toSelectSQL(expressionSub3);
        Assert.assertEquals((String)expressionSub1.expression(), (String)"ANY uid_ IN uid SATISFIES LOWER( uid_ ) LIKE $uid_any END");
        Assert.assertEquals((String)querySub3, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES LOWER( uid_ ) LIKE \"%test%%z\" END");
        Filter filterSub4 = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"uid"), null, (String[])new String[]{"test"}, (String)"z").multiValued(3);
        ConvertedExpression expressionSub4 = this.simpleConverter.convertToCouchbaseFilter(filterSub4, null, null);
        String querySub4 = this.toSelectSQL(expressionSub4);
        Assert.assertEquals((String)expressionSub1.expression(), (String)"ANY uid_ IN uid SATISFIES LOWER( uid_ ) LIKE $uid_any END");
        Assert.assertEquals((String)querySub4, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES LOWER( uid_ ) LIKE \"%test%%z\" END");
    }

    @Test
    public void checkLowerFilters() throws SearchException {
        Filter userUidFilter1 = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)"test");
        ConvertedExpression expressionUserUid1 = this.simpleConverter.convertToCouchbaseFilter(userUidFilter1, null, null);
        String queryUserUid1 = this.toSelectSQL(expressionUserUid1);
        Assert.assertEquals((String)expressionUserUid1.expression(), (String)"LOWER( uid ) = $uid");
        Assert.assertEquals((String)queryUserUid1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE LOWER( uid ) = \"test\"");
    }

    @Test
    public void checkMultivaluedLowerFilters() throws SearchException {
        Filter userUidFilter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)"test").multiValued();
        ConvertedExpression expressionUserUid = this.simpleConverter.convertToCouchbaseFilter(userUidFilter, null, null);
        String queryUserUid = this.toSelectSQL(expressionUserUid);
        Assert.assertEquals((String)expressionUserUid.expression(), (String)"ANY uid_ IN uid SATISFIES LOWER( uid_ ) = $uid END");
        Assert.assertEquals((String)queryUserUid, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ANY uid_ IN uid SATISFIES LOWER( uid_ ) = \"test\" END");
    }

    @Test
    public void checkSinglevaluedLowerFilters() throws SearchException {
        Filter userUidFilter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)"test").multiValued(Boolean.valueOf(false));
        ConvertedExpression expressionUserUid = this.simpleConverter.convertToCouchbaseFilter(userUidFilter, null, null);
        String queryUserUid = this.toSelectSQL(expressionUserUid);
        Assert.assertEquals((String)expressionUserUid.expression(), (String)"LOWER( uid ) = $uid");
        Assert.assertEquals((String)queryUserUid, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE LOWER( uid ) = \"test\"");
    }

    @Test
    public void checkNotFilters() throws SearchException {
        Filter notFilter1 = Filter.createNOTFilter((Filter)Filter.createLessOrEqualFilter((String)"age", (Object)23));
        ConvertedExpression expressionNot1 = this.simpleConverter.convertToCouchbaseFilter(notFilter1, null, null);
        String queryUserUid1 = this.toSelectSQL(expressionNot1);
        Assert.assertEquals((String)expressionNot1.expression(), (String)"NOT ( age <= $age )");
        Assert.assertEquals((String)queryUserUid1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE NOT ( age <= 23 )");
        Filter notFilter2 = Filter.createNOTFilter((Filter)Filter.createANDFilter((Filter[])new Filter[]{Filter.createLessOrEqualFilter((String)"age", (Object)23), Filter.createGreaterOrEqualFilter((String)"age", (Object)25)}));
        ConvertedExpression expressionNot2 = this.simpleConverter.convertToCouchbaseFilter(notFilter2, null, null);
        String queryUserUid2 = this.toSelectSQL(expressionNot2);
        Assert.assertEquals((String)expressionNot2.expression(), (String)"NOT ( ( age <= $age AND age >= $_age_0 ) )");
        Assert.assertEquals((String)queryUserUid2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE NOT ( ( age <= 23 AND age >= 25 ) )");
    }

    @Test
    public void checkAndFilters() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test");
        Filter filterPresence1 = Filter.createPresenceFilter((String)"mail");
        Filter filterLe1 = Filter.createLessOrEqualFilter((String)"age", (Object)23);
        Filter filterAnd1 = Filter.createANDFilter((Filter[])new Filter[]{filterPresence1, filterEq1, filterLe1});
        ConvertedExpression expressionAnd1 = this.simpleConverter.convertToCouchbaseFilter(filterAnd1, null, null);
        String queryAnd1 = this.toSelectSQL(expressionAnd1);
        Assert.assertEquals((String)expressionAnd1.expression(), (String)"( mail IS NOT MISSING AND ( ( uid = $uid ) OR ( $uid IN uid ) ) AND age <= $age )");
        Assert.assertEquals((String)queryAnd1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ( mail IS NOT MISSING AND ( ( uid = \"test\" ) OR ( \"test\" IN uid ) ) AND age <= 23 )");
    }

    @Test
    public void checkOrFilters() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test");
        Filter filterPresence1 = Filter.createPresenceFilter((String)"mail");
        Filter filterLe1 = Filter.createLessOrEqualFilter((String)"age", (Object)23);
        Filter filterOr1 = Filter.createORFilter((Filter[])new Filter[]{filterPresence1, filterEq1, filterLe1});
        ConvertedExpression expressionAnd1 = this.simpleConverter.convertToCouchbaseFilter(filterOr1, null, null);
        String queryAnd1 = this.toSelectSQL(expressionAnd1);
        Assert.assertEquals((String)expressionAnd1.expression(), (String)"( mail IS NOT MISSING OR ( ( uid = $uid ) OR ( $uid IN uid ) ) OR age <= $age )");
        Assert.assertEquals((String)queryAnd1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ( mail IS NOT MISSING OR ( ( uid = \"test\" ) OR ( \"test\" IN uid ) ) OR age <= 23 )");
    }

    @Test
    public void checkOrJoinFilters() throws SearchException {
        Filter filterEq1 = Filter.createEqualityFilter((String)"uid", (Object)"test");
        Filter filterEq2 = Filter.createEqualityFilter((String)"uid", (Object)"test2");
        Filter filterEq3 = Filter.createEqualityFilter((String)"uid", (Object)"test3");
        Filter filterOr1 = Filter.createORFilter((Filter[])new Filter[]{filterEq1, filterEq2, filterEq3}).multiValued(Boolean.valueOf(false));
        ConvertedExpression expressionOr1 = this.simpleConverter.convertToCouchbaseFilter(filterOr1, null, null);
        String queryOr1 = this.toSelectSQL(expressionOr1);
        Assert.assertEquals((String)expressionOr1.expression(), (String)"uid IN [ $uid, $_uid_0, $_uid_1 ]");
        Assert.assertEquals((String)queryOr1, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE uid IN [ \"test\", \"test2\", \"test3\" ]");
        Filter filterOr2 = Filter.createORFilter((Filter[])new Filter[]{filterEq1, filterEq2, filterEq3});
        ConvertedExpression expressionOr2 = this.simpleConverter.convertToCouchbaseFilter(filterOr2, null, null);
        String queryOr2 = this.toSelectSQL(expressionOr2);
        Assert.assertEquals((String)expressionOr2.expression(), (String)"( ( ( uid = $uid ) OR ( $uid IN uid ) ) OR ( ( uid = $_uid_0 ) OR ( $_uid_0 IN uid ) ) OR ( ( uid = $_uid_1 ) OR ( $_uid_1 IN uid ) ) )");
        Assert.assertEquals((String)queryOr2, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ( ( ( uid = \"test\" ) OR ( \"test\" IN uid ) ) OR ( ( uid = \"test2\" ) OR ( \"test2\" IN uid ) ) OR ( ( uid = \"test3\" ) OR ( \"test3\" IN uid ) ) )");
    }

    @Test
    public void checkOrWithLowerCaseFilter() throws SearchException {
        Filter displayNameFilter;
        Filter descriptionFilter;
        boolean useLowercaseFilter = true;
        String[] targetArray = new String[]{"test_value"};
        if (useLowercaseFilter) {
            descriptionFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"description"), null, (String[])targetArray, null);
            displayNameFilter = Filter.createSubstringFilter((Filter)Filter.createLowercaseFilter((String)"displayName"), null, (String[])targetArray, null);
        } else {
            descriptionFilter = Filter.createSubstringFilter((String)"description", null, (String[])targetArray, null);
            displayNameFilter = Filter.createSubstringFilter((String)"displayName", null, (String[])targetArray, null);
        }
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{descriptionFilter, displayNameFilter});
        Filter typeFilter = Filter.createEqualityFilter((String)"jansScrTyp", (Object)"person_authentication");
        Filter filter = Filter.createANDFilter((Filter[])new Filter[]{searchFilter, typeFilter});
        ConvertedExpression expression = this.simpleConverter.convertToCouchbaseFilter(filter, null, null);
        String query = this.toSelectSQL(expression);
        Assert.assertEquals((String)expression.expression(), (String)"( ( LOWER( description ) LIKE $description_any OR LOWER( displayName ) LIKE $displayName_any ) AND ( ( jansScrTyp = $jansScrTyp ) OR ( $jansScrTyp IN jansScrTyp ) ) )");
        Assert.assertEquals((String)query, (String)"SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE ( ( LOWER( description ) LIKE \"%test_value%\" OR LOWER( displayName ) LIKE \"%test_value%\" ) AND ( ( jansScrTyp = \"person_authentication\" ) OR ( \"person_authentication\" IN jansScrTyp ) ) )");
    }

    private String toSelectSQL(ConvertedExpression convertedExpression) {
        String select = String.format("SELECT jans_doc.* FROM `gluu` AS jans_doc WHERE %s", convertedExpression.expression());
        JsonObject params = convertedExpression.getQueryParameters();
        for (String name : params.getNames()) {
            Object value;
            Object replaceValue = value = params.get(name);
            if (value instanceof String) {
                replaceValue = "\"" + value + "\"";
            }
            String searchName = "\\$" + name;
            int subIndex = select.indexOf("%$" + name + "%");
            if (subIndex != -1) {
                searchName = "%" + searchName + "%";
                replaceValue = "\"%" + value + "%\"";
            }
            select = select.replaceAll(searchName, replaceValue.toString());
        }
        select = select.replaceAll("\"\"%", "%").replaceAll("%\"\"", "%");
        return select;
    }

    private static Date getUtcDateFromMillis(long millis) {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(millis);
        calendar.set(15, TimeZone.getTimeZone("UTC").getRawOffset());
        Date date = calendar.getTime();
        return date;
    }
}

