/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.couchbase.operation.impl;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.UpsertOptions;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.client.java.query.QueryStatus;
import io.jans.orm.couchbase.impl.CouchbaseBatchOperationWraper;
import io.jans.orm.couchbase.model.BucketMapping;
import io.jans.orm.couchbase.model.ConvertedExpression;
import io.jans.orm.couchbase.model.SearchReturnDataType;
import io.jans.orm.couchbase.operation.CouchbaseOperationService;
import io.jans.orm.couchbase.operation.impl.CouchbaseConnectionProvider;
import io.jans.orm.couchbase.operation.watch.OperationDurationUtil;
import io.jans.orm.exception.AuthenticationException;
import io.jans.orm.exception.operation.ConnectionException;
import io.jans.orm.exception.operation.DeleteException;
import io.jans.orm.exception.operation.DuplicateEntryException;
import io.jans.orm.exception.operation.EntryNotFoundException;
import io.jans.orm.exception.operation.PersistenceException;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.extension.PersistenceExtension;
import io.jans.orm.model.BatchOperation;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.Sort;
import io.jans.orm.model.SortOrder;
import io.jans.orm.operation.auth.PasswordEncryptionHelper;
import io.jans.orm.operation.auth.PasswordEncryptionMethod;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseOperationServiceImpl
implements CouchbaseOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseOperationServiceImpl.class);
    private Properties props;
    private CouchbaseConnectionProvider connectionProvider;
    private QueryScanConsistency queryScanConsistency = QueryScanConsistency.NOT_BOUNDED;
    private boolean ignoreAttributeQueryScanConsistency = false;
    private boolean attemptWithoutAttributeQueryScanConsistency = true;
    private boolean enableScopeSupport = false;
    private boolean disableAttributeMapping = false;
    private PersistenceExtension persistenceExtension;

    public CouchbaseOperationServiceImpl() {
    }

    public CouchbaseOperationServiceImpl(Properties props, CouchbaseConnectionProvider connectionProvider) {
        this.props = props;
        this.connectionProvider = connectionProvider;
        this.init();
    }

    private void init() {
        if (this.props.containsKey("connection.scan-consistency")) {
            String queryScanConsistencyString = StringHelper.toUpperCase((String)this.props.get("connection.scan-consistency").toString());
            this.queryScanConsistency = QueryScanConsistency.valueOf((String)queryScanConsistencyString);
        }
        if (this.props.containsKey("connection.ignore-attribute-scan-consistency")) {
            this.ignoreAttributeQueryScanConsistency = StringHelper.toBoolean((String)this.props.get("connection.ignore-attribute-scan-consistency").toString(), (boolean)this.ignoreAttributeQueryScanConsistency);
        }
        if (this.props.containsKey("connection.attempt-without-attribute-scan-consistency")) {
            this.attemptWithoutAttributeQueryScanConsistency = StringHelper.toBoolean((String)this.props.get("attempt-without-attribute-scan-consistency").toString(), (boolean)this.attemptWithoutAttributeQueryScanConsistency);
        }
        if (this.props.containsKey("connection.enable-scope-support")) {
            this.enableScopeSupport = StringHelper.toBoolean((String)this.props.get("connection.enable-scope-support").toString(), (boolean)this.enableScopeSupport);
        }
        if (this.props.containsKey("connection.disable-attribute-mapping")) {
            this.disableAttributeMapping = StringHelper.toBoolean((String)this.props.get("connection.disable-attribute-mapping").toString(), (boolean)this.disableAttributeMapping);
        }
        LOG.info("Option queryScanConsistency: " + this.queryScanConsistency);
        LOG.info("Option ignoreAttributeQueryScanConsistency: " + this.ignoreAttributeQueryScanConsistency);
        LOG.info("Option enableScopeSupport: " + this.enableScopeSupport);
        LOG.info("Option disableAttributeMapping: " + this.disableAttributeMapping);
    }

    @Override
    public CouchbaseConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public boolean authenticate(String key, String password, String objectClass) throws ConnectionException, SearchException, AuthenticationException {
        return this.authenticateImpl(key, password);
    }

    private boolean authenticateImpl(String key, String password) throws SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = false;
        if (password != null) {
            JsonObject entry = this.lookup(key, "userPassword");
            Object userPasswordObj = entry.get("userPassword");
            String userPassword = null;
            if (userPasswordObj instanceof JsonArray) {
                userPassword = ((JsonArray)userPasswordObj).getString(0);
            } else if (userPasswordObj instanceof String) {
                userPassword = (String)userPasswordObj;
            }
            if (userPassword != null) {
                result = this.persistenceExtension == null ? PasswordEncryptionHelper.compareCredentials((String)password, (String)userPassword) : this.persistenceExtension.compareHashedPasswords(password, userPassword);
            }
        }
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        OperationDurationUtil.instance().logDebug("Couchbase operation: bind, duration: {}, bucket: {}, key: {}", new Object[]{duration, bucketMapping.getBucketName(), key});
        return result;
    }

    @Override
    public boolean addEntry(String key, JsonObject jsonObject) throws DuplicateEntryException, PersistenceException {
        return this.addEntry(key, jsonObject, 0);
    }

    @Override
    public boolean addEntry(String key, JsonObject jsonObject, Integer expiration) throws DuplicateEntryException, PersistenceException {
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        boolean result = this.addEntryImpl(bucketMapping, key, jsonObject, expiration);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: add, duration: {}, bucket: {}, key: {}, json: {}", new Object[]{duration, bucketMapping.getBucketName(), key, jsonObject});
        return result;
    }

    private boolean addEntryImpl(BucketMapping bucketMapping, String key, JsonObject jsonObject, Integer expiration) throws PersistenceException {
        try {
            MutationResult result;
            UpsertOptions upsertOptions = UpsertOptions.upsertOptions();
            if (expiration != null) {
                upsertOptions = upsertOptions.expiry(Duration.ofSeconds(expiration.intValue()));
            }
            if ((result = bucketMapping.getBucket().defaultCollection().upsert(key, (Object)jsonObject, upsertOptions)) != null) {
                return true;
            }
        }
        catch (CouchbaseException ex) {
            throw new PersistenceException(String.format("Failed to add entry with key '%s'", key), (Throwable)ex);
        }
        return false;
    }

    @Deprecated
    protected boolean updateEntry(String key, JsonObject attrs) throws UnsupportedOperationException, PersistenceException {
        ArrayList<MutateInSpec> mods = new ArrayList<MutateInSpec>();
        for (Map.Entry attrEntry : attrs.toMap().entrySet()) {
            String attributeName = (String)attrEntry.getKey();
            Object attributeValue = attrEntry.getValue();
            if (attributeName.equalsIgnoreCase("objectClass") || attributeName.equalsIgnoreCase("dn") || attributeName.equalsIgnoreCase("userPassword") || attributeValue == null) continue;
            mods.add((MutateInSpec)MutateInSpec.replace((String)attributeName, attributeValue));
        }
        return this.updateEntry(key, mods, null);
    }

    @Override
    public boolean updateEntry(String key, List<MutateInSpec> mods, Integer expiration) throws PersistenceException {
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        boolean result = this.updateEntryImpl(bucketMapping, key, mods, expiration);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: modify, duration: {}, bucket: {}, key: {}, mods: {}", new Object[]{duration, bucketMapping.getBucketName(), key, mods});
        return result;
    }

    private boolean updateEntryImpl(BucketMapping bucketMapping, String key, List<MutateInSpec> mods, Integer expiration) throws PersistenceException {
        try {
            MutateInResult result;
            MutateInOptions options = MutateInOptions.mutateInOptions();
            if (expiration != null) {
                options.expiry(Duration.ofSeconds(expiration.intValue()));
            }
            return (result = bucketMapping.getBucket().defaultCollection().mutateIn(key, mods, options)) != null;
        }
        catch (CouchbaseException ex) {
            throw new PersistenceException("Failed to update entry", (Throwable)ex);
        }
    }

    @Override
    public boolean delete(String key) throws EntryNotFoundException {
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        boolean result = this.deleteImpl(bucketMapping, key);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: delete, duration: {}, bucket: {}, key: {}", new Object[]{duration, bucketMapping.getBucketName(), key});
        return result;
    }

    private boolean deleteImpl(BucketMapping bucketMapping, String key) throws EntryNotFoundException {
        try {
            MutationResult result = bucketMapping.getBucket().defaultCollection().remove(key);
            return result != null;
        }
        catch (CouchbaseException ex) {
            throw new EntryNotFoundException(String.format("Failed to delete entry by key '%s'", key), (Throwable)ex);
        }
    }

    @Override
    public int delete(String key, QueryScanConsistency queryScanConsistency, ConvertedExpression expression, int count) throws DeleteException {
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        QueryScanConsistency useQueryScanConsistency = this.getQueryScanConsistency(queryScanConsistency, false);
        int result = this.deleteImpl(bucketMapping, key, useQueryScanConsistency, expression, count);
        String attemptInfo = this.getScanAttemptLogInfo(queryScanConsistency, useQueryScanConsistency, false);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: delete_search, duration: {}, bucket: {}, key: {}, expression: {}, count: {}, consistency: {}{}", new Object[]{duration, bucketMapping.getBucketName(), key, expression, count, useQueryScanConsistency, attemptInfo});
        return result;
    }

    private int deleteImpl(BucketMapping bucketMapping, String key, QueryScanConsistency queryScanConsistency, ConvertedExpression expression, int count) throws DeleteException {
        StringBuilder query = new StringBuilder("DELETE FROM `").append(bucketMapping.getBucketName()).append("` WHERE ").append(expression.expression());
        if (this.enableScopeSupport) {
            query.append("AND META().id LIKE ").append(key).append("%");
        }
        query.append(" LIMIT ").append(count).append(" RETURNING default.*");
        LOG.debug("Execution query: '" + query + "'");
        QueryOptions queryOptions = QueryOptions.queryOptions().scanConsistency(queryScanConsistency).parameters(expression.getQueryParameters());
        QueryResult result = this.connectionProvider.getCluster().query(query.toString(), queryOptions);
        if (QueryStatus.SUCCESS != result.metaData().status()) {
            throw new DeleteException(String.format("Failed to delete entries. Query: '%s'. Warnings: '%s'", query, result.metaData().warnings()));
        }
        return result.rowsAsObject().size();
    }

    @Override
    public boolean deleteRecursively(String key) throws EntryNotFoundException, DeleteException {
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        boolean result = this.deleteRecursivelyImpl(bucketMapping, key);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: delete_tree, duration: {}, bucket: {}, key: {}", new Object[]{duration, bucketMapping.getBucketName(), key});
        return result;
    }

    private boolean deleteRecursivelyImpl(BucketMapping bucketMapping, String key) throws EntryNotFoundException, DeleteException {
        try {
            if (this.enableScopeSupport) {
                StringBuilder query = new StringBuilder("DELETE FROM `").append(bucketMapping.getBucketName()).append("` WHERE ").append("META().id LIKE $1%");
                LOG.debug("Execution query: '" + query + "'");
                QueryOptions queryOptions = QueryOptions.queryOptions().scanConsistency(this.queryScanConsistency).parameters(JsonArray.from((Object[])new Object[]{key}));
                QueryResult result = this.connectionProvider.getCluster().query(query.toString(), queryOptions);
                if (QueryStatus.SUCCESS != result.metaData().status()) {
                    throw new DeleteException(String.format("Failed to delete entries. Query: '%s'. Warnings: '%s'", query, result.metaData().warnings()));
                }
                return true;
            }
            LOG.warn("Removing only base key without sub-tree: " + key);
            this.delete(key);
            return true;
        }
        catch (CouchbaseException ex) {
            throw new DeleteException("Failed to delete entry", (Throwable)ex);
        }
    }

    @Override
    public JsonObject lookup(String key, String ... attributes) throws SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        JsonObject result = this.lookupImpl(bucketMapping, key, attributes);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: lookup, duration: {}, bucket: {}, key: {}, attributes: {}", new Object[]{duration, bucketMapping.getBucketName(), key, attributes});
        return result;
    }

    private JsonObject lookupImpl(BucketMapping bucketMapping, String key, String ... attributes) throws SearchException {
        try {
            Bucket bucket = bucketMapping.getBucket();
            if (ArrayHelper.isEmpty((Object[])attributes)) {
                JsonObject doc = bucket.defaultCollection().get(key).contentAsObject();
                if (doc != null) {
                    return doc;
                }
            } else {
                if (attributes.length > 16) {
                    JsonObject doc = bucket.defaultCollection().get(key).contentAsObject();
                    HashSet<String> docAtributesKeep = new HashSet<String>(Arrays.asList(attributes));
                    Iterator it = doc.getNames().iterator();
                    while (it.hasNext()) {
                        String docAtribute = (String)it.next();
                        if (docAtributesKeep.contains(docAtribute)) continue;
                        it.remove();
                    }
                    return doc;
                }
                GetOptions options = GetOptions.getOptions().project(Arrays.asList(attributes));
                JsonObject doc = bucket.defaultCollection().get(key, options).contentAsObject();
                if (doc != null) {
                    return doc;
                }
            }
        }
        catch (CouchbaseException ex) {
            if (ResponseStatus.SUBDOC_FAILURE == ex.context().responseStatus()) {
                return JsonObject.create();
            }
            throw new SearchException(String.format("Failed to lookup entry by key '%s'", key), (Throwable)ex);
        }
        throw new SearchException(String.format("Failed to lookup entry by key '%s'", key));
    }

    @Override
    public <O> PagedResult<JsonObject> search(String key, QueryScanConsistency queryScanConsistency, ConvertedExpression expression, SearchScope scope, String[] attributes, Sort[] orderBy, CouchbaseBatchOperationWraper<O> batchOperationWraper, SearchReturnDataType returnDataType, int start, int count, int pageSize) throws SearchException {
        QueryScanConsistency useQueryScanConsistency2;
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        boolean secondTry = false;
        QueryScanConsistency useQueryScanConsistency = this.getQueryScanConsistency(queryScanConsistency, this.attemptWithoutAttributeQueryScanConsistency);
        PagedResult<JsonObject> result = null;
        int attemps = 20;
        while (true) {
            --attemps;
            try {
                result = this.searchImpl(bucketMapping, key, useQueryScanConsistency, expression, scope, attributes, orderBy, batchOperationWraper, returnDataType, start, count, pageSize);
            }
            catch (SearchException ex) {
                if (ex.getErrorCode() != 5000) {
                    throw ex;
                }
                LOG.warn("Waiting for Indexer Warmup...");
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (attemps > 0) continue;
            }
            break;
        }
        if (!(result != null && result.getTotalEntriesCount() != 0 || (useQueryScanConsistency2 = this.getQueryScanConsistency(queryScanConsistency, false)).equals((Object)useQueryScanConsistency))) {
            useQueryScanConsistency = useQueryScanConsistency2;
            result = this.searchImpl(bucketMapping, key, useQueryScanConsistency, expression, scope, attributes, orderBy, batchOperationWraper, returnDataType, start, count, pageSize);
            secondTry = true;
        }
        String attemptInfo = this.getScanAttemptLogInfo(queryScanConsistency, useQueryScanConsistency, secondTry);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: search, duration: {}, bucket: {}, key: {}, expression: {}, scope: {}, attributes: {}, orderBy: {}, batchOperationWraper: {}, returnDataType: {}, start: {}, count: {}, pageSize: {}, consistency: {}{}", new Object[]{duration, bucketMapping.getBucketName(), key, expression, scope, attributes, orderBy, batchOperationWraper, returnDataType, start, count, pageSize, useQueryScanConsistency, attemptInfo});
        return result;
    }

    private <O> PagedResult<JsonObject> searchImpl(BucketMapping bucketMapping, String key, QueryScanConsistency queryScanConsistency, ConvertedExpression expression, SearchScope scope, String[] attributes, Sort[] orderBy, CouchbaseBatchOperationWraper<O> batchOperationWraper, SearchReturnDataType returnDataType, int start, int count, int pageSize) throws SearchException {
        BatchOperation<O> batchOperation = null;
        if (batchOperationWraper != null) {
            batchOperation = batchOperationWraper.getBatchOperation();
        }
        if (LOG.isTraceEnabled() && StringHelper.equalsIgnoreCase((String)key, (String)"_")) {
            LOG.trace("Search in whole DB tree", (Throwable)new Exception());
        }
        StringBuilder finalExpression = new StringBuilder(expression.expression());
        if (this.enableScopeSupport) {
            if (SearchScope.BASE == scope) {
                finalExpression.append(" AND META().id NOT LIKE ").append(key).append("\\\\_%\\\\_");
            } else {
                finalExpression.append(" AND META().id LIKE ").append(key).append("%");
            }
        } else if (scope != null) {
            LOG.debug("Ignoring scope '" + scope + " for expression: " + expression);
        }
        Object[] select = attributes;
        if (ArrayHelper.isEmpty((Object[])select)) {
            select = new String[]{"jans_doc.*", "dn"};
        } else if (select.length == 1 && StringHelper.isEmpty((String)select[0])) {
            select = new String[]{"dn"};
        } else {
            boolean hasDn = Arrays.asList(select).contains("dn");
            if (!hasDn) {
                select = (String[])ArrayHelper.arrayMerge((Object[][])new String[][]{select, {"dn"}});
            }
        }
        StringBuilder baseQuery = new StringBuilder("SELECT ").append(StringHelper.toString((Object[])this.backticksAttributes((String[])select))).append(" FROM `").append(bucketMapping.getBucketName()).append("` AS jans_doc ").append("WHERE ").append((CharSequence)finalExpression);
        StringBuilder baseQueryWithOrder = new StringBuilder(baseQuery);
        if (ArrayHelper.isNotEmpty((Object[])orderBy)) {
            baseQueryWithOrder.append(" ORDER BY ");
            for (int i = 0; i < orderBy.length; ++i) {
                if (i > 0) {
                    baseQueryWithOrder.append(", ");
                }
                Sort order = orderBy[i];
                baseQueryWithOrder.append(order.getName());
                if (order.getSortOrder() == null || SortOrder.DEFAULT == order.getSortOrder()) continue;
                baseQueryWithOrder.append(" ").append(order.getSortOrder().getShortValue());
            }
        }
        QueryOptions queryOptions = QueryOptions.queryOptions().scanConsistency(queryScanConsistency).parameters(expression.getQueryParameters());
        ArrayList searchResultList = new ArrayList();
        int totalEntriesCount = 0;
        if (SearchReturnDataType.SEARCH == returnDataType || SearchReturnDataType.SEARCH_COUNT == returnDataType) {
            QueryResult lastResult = null;
            if (pageSize > 0) {
                StringBuilder query = null;
                int lastCountRows = 0;
                try {
                    int currentLimit;
                    do {
                        boolean collectSearchResult = true;
                        currentLimit = pageSize;
                        if (count > 0) {
                            currentLimit = Math.min(pageSize, count - totalEntriesCount);
                        }
                        query = new StringBuilder(baseQueryWithOrder).append(" LIMIT ").append(currentLimit).append(" OFFSET ").append(start + totalEntriesCount);
                        LOG.debug("Execution query: '" + query + "'");
                        lastResult = this.connectionProvider.getCluster().query(query.toString(), queryOptions);
                        if (QueryStatus.SUCCESS != lastResult.metaData().status()) {
                            throw new SearchException(String.format("Failed to search entries. Query: '%s'. Warnings: '%s'", query, lastResult.metaData().warnings()));
                        }
                        List lastSearchResultList = lastResult.rowsAsObject();
                        lastCountRows = lastSearchResultList.size();
                        if (batchOperation != null) {
                            collectSearchResult = batchOperation.collectSearchResult(lastCountRows);
                        }
                        if (collectSearchResult) {
                            searchResultList.addAll(lastSearchResultList);
                        }
                        if (batchOperation == null || lastCountRows <= 0) continue;
                        List<O> entries = batchOperationWraper.createEntities(lastSearchResultList);
                        batchOperation.performAction(entries);
                    } while ((count <= 0 || (totalEntriesCount += lastCountRows) < count) && lastCountRows >= currentLimit && lastCountRows > 0);
                }
                catch (CouchbaseException ex) {
                    throw new SearchException("Failed to search entries. Query: '" + query + "'", (Throwable)ex);
                }
            }
            try {
                StringBuilder query = new StringBuilder(baseQueryWithOrder);
                if (count > 0) {
                    query.append(" LIMIT ").append(count);
                }
                if (start > 0) {
                    query.append(" OFFSET ").append(start);
                }
                LOG.debug("Execution query: '" + query + "'");
                lastResult = this.connectionProvider.getCluster().query(query.toString(), queryOptions);
                if (QueryStatus.SUCCESS != lastResult.metaData().status()) {
                    throw new SearchException(String.format("Failed to search entries. Query: '%s'. Warnings: '%s'", query, lastResult.metaData().warnings()));
                }
                searchResultList.addAll(lastResult.rowsAsObject());
            }
            catch (CouchbaseException ex) {
                throw new SearchException("Failed to search entries. Query: '" + baseQuery.toString() + "'", (Throwable)ex);
            }
        }
        ArrayList<JsonObject> resultRows = new ArrayList<JsonObject>(searchResultList.size());
        for (JsonObject row : searchResultList) {
            resultRows.add(row);
        }
        PagedResult result = new PagedResult();
        result.setEntries(resultRows);
        result.setEntriesCount(resultRows.size());
        result.setStart(start);
        if (SearchReturnDataType.COUNT == returnDataType || SearchReturnDataType.SEARCH_COUNT == returnDataType) {
            StringBuilder selectCountQuery = new StringBuilder("SELECT COUNT(*) as TOTAL").append(" FROM `").append(bucketMapping.getBucketName()).append("` AS jans_doc ").append("WHERE ").append((CharSequence)finalExpression);
            try {
                LOG.debug("Calculating count. Execution query: '" + selectCountQuery + "'");
                QueryResult countResult = this.connectionProvider.getCluster().query(selectCountQuery.toString(), queryOptions);
                if (QueryStatus.SUCCESS != countResult.metaData().status() && countResult.rowsAsObject().size() != 1) {
                    throw new SearchException(String.format("Failed to calculate count entries. Query: '%s'. Warnings: '%s'", selectCountQuery, countResult.metaData().warnings()));
                }
                result.setTotalEntriesCount(((JsonObject)countResult.rowsAsObject().get(0)).getInt("TOTAL").intValue());
            }
            catch (CouchbaseException ex) {
                throw new SearchException("Failed to calculate count entries. Query: '" + selectCountQuery.toString() + "'", (Throwable)ex);
            }
        } else {
            result.setTotalEntriesCount(totalEntriesCount);
        }
        return result;
    }

    private String[] backticksAttributes(String[] attributes) {
        if (ArrayHelper.isEmpty((Object[])attributes)) {
            return attributes;
        }
        String[] resultAttributes = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            resultAttributes[i] = attributes[i].contains("*") ? attributes[i] : "`" + attributes[i] + "`";
        }
        return resultAttributes;
    }

    @Override
    public String[] createStoragePassword(String[] passwords) {
        if (ArrayHelper.isEmpty((Object[])passwords)) {
            return passwords;
        }
        String[] results = new String[passwords.length];
        for (int i = 0; i < passwords.length; ++i) {
            results[i] = this.persistenceExtension == null ? PasswordEncryptionHelper.createStoragePassword((String)passwords[i], (PasswordEncryptionMethod)this.connectionProvider.getPasswordEncryptionMethod()) : this.persistenceExtension.createHashedPassword(passwords[i]);
        }
        return results;
    }

    @Override
    public boolean isBinaryAttribute(String attribute) {
        return this.connectionProvider.isBinaryAttribute(attribute);
    }

    @Override
    public boolean isCertificateAttribute(String attribute) {
        return this.connectionProvider.isCertificateAttribute(attribute);
    }

    private QueryScanConsistency getQueryScanConsistency(QueryScanConsistency operationQueryScanConsistency, boolean ignore) {
        if (ignore) {
            return this.queryScanConsistency;
        }
        if (this.ignoreAttributeQueryScanConsistency) {
            return this.queryScanConsistency;
        }
        if (operationQueryScanConsistency != null) {
            return operationQueryScanConsistency;
        }
        return this.queryScanConsistency;
    }

    public QueryScanConsistency getQueryScanConsistency() {
        return this.queryScanConsistency;
    }

    public boolean isDisableAttributeMapping() {
        return this.disableAttributeMapping;
    }

    @Override
    public boolean destroy() {
        boolean result = true;
        if (this.connectionProvider != null) {
            try {
                this.connectionProvider.destroy();
            }
            catch (Exception ex) {
                LOG.error("Failed to destroy provider correctly");
                result = false;
            }
        }
        return result;
    }

    public boolean isConnected() {
        return this.connectionProvider.isConnected();
    }

    protected String getScanAttemptLogInfo(QueryScanConsistency queryScanConsistency, QueryScanConsistency usedQueryScanConsistency, boolean secondTry) {
        String attemptInfo = "";
        if (secondTry) {
            attemptInfo = ", attempt: second";
        } else {
            QueryScanConsistency useQueryScanConsistency2 = this.getQueryScanConsistency(queryScanConsistency, false);
            if (!useQueryScanConsistency2.equals((Object)usedQueryScanConsistency)) {
                attemptInfo = ", attempt: first";
            }
        }
        return attemptInfo;
    }

    public void setPersistenceExtension(PersistenceExtension persistenceExtension) {
        this.persistenceExtension = persistenceExtension;
    }

    public boolean isSupportObjectClass(String objectClass) {
        return true;
    }

    @Override
    public String toInternalAttribute(String attributeName) {
        return attributeName;
    }

    @Override
    public String[] toInternalAttributes(String[] attributeNames) {
        return attributeNames;
    }

    @Override
    public String fromInternalAttribute(String internalAttributeName) {
        return internalAttributeName;
    }

    @Override
    public String[] fromInternalAttributes(String[] internalAttributeNames) {
        return internalAttributeNames;
    }

    @Override
    public String encodeTime(Date date) {
        if (date == null) {
            return null;
        }
        try {
            String utcDate = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(date.getTime()));
            return utcDate;
        }
        catch (DateTimeException ex) {
            LOG.error("Cannot format date '{}' as ISO", (Object)date, (Object)ex);
            return null;
        }
    }

    @Override
    public Date decodeTime(String date, boolean silent) {
        if (StringHelper.isEmpty((String)date)) {
            return null;
        }
        Object dateZ = date.endsWith("Z") ? date : date + "Z";
        try {
            return new Date(Instant.parse((CharSequence)dateZ).toEpochMilli());
        }
        catch (DateTimeParseException ex) {
            if (!silent) {
                LOG.error("Failed to decode generalized time '{}'", (Object)date, (Object)ex);
            }
            return null;
        }
    }
}

