/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.hybrid.impl;

import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.exception.operation.ConfigurationException;
import io.jans.orm.hybrid.impl.HybridEntryManager;
import io.jans.orm.hybrid.impl.HybridPersistenceOperationService;
import io.jans.orm.operation.PersistenceOperationService;
import io.jans.orm.service.BaseFactoryService;
import io.jans.orm.util.PropertiesHelper;
import io.jans.orm.util.StringHelper;
import io.jans.orm.util.properties.FileConfiguration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HybridEntryManagerFactory
implements PersistenceEntryManagerFactory {
    public static final String BASE_DIR = System.getProperty("jans.base") != null ? System.getProperty("jans.base") : (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null)));
    public static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    public static final String PERSISTENCE_TYPE = PersistenceEntryManager.PERSITENCE_TYPES.hybrid.name();
    public static final String PROPERTIES_FILE = "jans-hybrid%s.properties";
    private static final Logger LOG = LoggerFactory.getLogger(HybridEntryManagerFactory.class);
    @Inject
    private BaseFactoryService persistanceFactoryService;
    private String[] persistenceTypes;
    private Properties hybridMappingProperties;

    public String getPersistenceType() {
        return PERSISTENCE_TYPE;
    }

    public HashMap<String, String> getConfigurationFileNames(String alias) {
        Object usedAlias = StringHelper.isEmpty((String)alias) ? "" : "-" + alias;
        HashMap<String, String> confs = new HashMap<String, String>();
        String confFileName = String.format(PROPERTIES_FILE, usedAlias);
        confs.put(PERSISTENCE_TYPE + (String)usedAlias, confFileName);
        HashMap<String, String> allConfs = this.getAllConfigurationFileNames(alias, confFileName);
        confs.putAll(allConfs);
        return confs;
    }

    private HashMap<String, String> getAllConfigurationFileNames(String alias, String confFileName) {
        HashMap<String, String> allConfs = new HashMap<String, String>();
        FileConfiguration fileConf = new FileConfiguration(DIR + confFileName);
        if (!fileConf.isLoaded()) {
            LOG.error("Unable to load configuration file '{}'", (Object)(DIR + confFileName));
            throw new ConfigurationException(String.format("Unable to load configuration file: '%s'", fileConf));
        }
        String storagesList = fileConf.getString("storages", null);
        if (StringHelper.isEmpty((String)storagesList)) {
            throw new ConfigurationException("'storages' key not exists or value is empty!");
        }
        for (String persistenceType : this.persistenceTypes = StringHelper.split((String)storagesList, (String)",")) {
            PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.persistanceFactoryService.getPersistenceEntryManagerFactory(persistenceType);
            if (persistenceEntryManagerFactory == null) {
                throw new ConfigurationException(String.format("Unable to get Persistence Entry Manager Factory by type '%s'", persistenceType));
            }
            String persistenceTypeAlias = this.persistanceFactoryService.getPersistenceTypeAlias(persistenceType);
            Map confs = persistenceEntryManagerFactory.getConfigurationFileNames(persistenceTypeAlias);
            allConfs.putAll(confs);
        }
        return allConfs;
    }

    public HybridEntryManager createEntryManager(Properties conf) {
        HashMap<String, PersistenceEntryManager> persistenceEntryManagers = new HashMap<String, PersistenceEntryManager>();
        ArrayList<PersistenceOperationService> operationServices = new ArrayList<PersistenceOperationService>();
        if (this.persistenceTypes == null) {
            Object hybridProperties = PropertiesHelper.findProperties((Properties)conf, (String)PERSISTENCE_TYPE, (String)"#");
            String storagesList = ((Properties)(hybridProperties = PropertiesHelper.filterProperties((Properties)hybridProperties, (String)"#"))).getProperty("storages", null);
            if (StringHelper.isEmpty((String)storagesList)) {
                throw new ConfigurationException("'storages' key not exists or value is empty!");
            }
            this.persistenceTypes = StringHelper.split((String)storagesList, (String)",");
        }
        for (String persistenceType : this.persistenceTypes) {
            PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.persistanceFactoryService.getPersistenceEntryManagerFactory(persistenceType);
            if (persistenceEntryManagerFactory == null) {
                throw new ConfigurationException(String.format("Unable to get Persistence Entry Manager Factory by type '%s'", persistenceType));
            }
            Properties entryManagerConf = PropertiesHelper.findProperties((Properties)conf, (String)persistenceType, (String)"#");
            PersistenceEntryManager persistenceEntryManager = persistenceEntryManagerFactory.createEntryManager(entryManagerConf);
            persistenceEntryManagers.put(persistenceType, persistenceEntryManager);
            operationServices.add(persistenceEntryManager.getOperationService());
        }
        this.hybridMappingProperties = PropertiesHelper.filterProperties((Properties)conf, (String)"#");
        HybridPersistenceOperationService hybridOperationService = new HybridPersistenceOperationService(operationServices);
        HybridEntryManager hybridEntryManager = new HybridEntryManager(this.hybridMappingProperties, persistenceEntryManagers, hybridOperationService);
        LOG.info("Created HybridEntryManager: {}", (Object)hybridOperationService);
        return hybridEntryManager;
    }

    public void initStandalone(BaseFactoryService persistanceFactoryService) {
        this.persistanceFactoryService = persistanceFactoryService;
    }
}

