/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.hybrid.impl;

import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.event.DeleteNotifier;
import io.jans.orm.exception.KeyConversionException;
import io.jans.orm.exception.MappingException;
import io.jans.orm.exception.operation.ConfigurationException;
import io.jans.orm.hybrid.impl.HybridEntryManagerFactory;
import io.jans.orm.hybrid.impl.HybridPersistenceOperationService;
import io.jans.orm.impl.BaseEntryManager;
import io.jans.orm.impl.GenericKeyConverter;
import io.jans.orm.impl.model.ParsedKey;
import io.jans.orm.model.AttributeData;
import io.jans.orm.model.AttributeDataModification;
import io.jans.orm.model.BatchOperation;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.SortOrder;
import io.jans.orm.reflect.property.PropertyAnnotation;
import io.jans.orm.search.filter.Filter;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridEntryManager
extends BaseEntryManager<HybridPersistenceOperationService>
implements Serializable {
    private static final long serialVersionUID = -1544664410881103105L;
    private static final Logger LOG = LoggerFactory.getLogger(HybridEntryManager.class);
    private static final GenericKeyConverter KEY_CONVERTER = new GenericKeyConverter();
    private Properties mappingProperties;
    private HashMap<String, PersistenceEntryManager> persistenceEntryManagers;
    private HybridPersistenceOperationService operationService;
    private PersistenceEntryManager defaultPersistenceEntryManager;
    private HashMap<String, PersistenceEntryManager> baseNameToEntryManagerMapping;

    public HybridEntryManager() {
    }

    public HybridEntryManager(Properties mappingProperties, HashMap<String, PersistenceEntryManager> persistenceEntryManagers, HybridPersistenceOperationService operationService) {
        this.mappingProperties = mappingProperties;
        this.persistenceEntryManagers = persistenceEntryManagers;
        this.operationService = operationService;
        this.init();
    }

    protected void init() {
        String defaultPersistenceType = this.mappingProperties.getProperty("storage.default", null);
        if (StringHelper.isEmpty((String)defaultPersistenceType) || this.persistenceEntryManagers.get(defaultPersistenceType) == null) {
            throw new ConfigurationException("Default persistence type is not defined!");
        }
        this.defaultPersistenceEntryManager = this.persistenceEntryManagers.get(defaultPersistenceType);
        this.baseNameToEntryManagerMapping = new HashMap();
        for (Map.Entry<String, PersistenceEntryManager> persistenceTypeEntry : this.persistenceEntryManagers.entrySet()) {
            String[] baseNames;
            String mapping = this.mappingProperties.getProperty(String.format("storage.%s.mapping", persistenceTypeEntry.getKey()), "");
            for (String baseName : baseNames = StringHelper.split((String)mapping, (String)",")) {
                this.baseNameToEntryManagerMapping.put(baseName, persistenceTypeEntry.getValue());
            }
        }
    }

    public void addDeleteSubscriber(DeleteNotifier subscriber) {
        if (this.persistenceEntryManagers == null) {
            return;
        }
        for (PersistenceEntryManager persistenceEntryManager : this.persistenceEntryManagers.values()) {
            persistenceEntryManager.addDeleteSubscriber(subscriber);
        }
    }

    @Deprecated
    public boolean authenticate(String bindDn, String password) {
        return this.authenticate(bindDn, null, password);
    }

    public <T> boolean authenticate(String bindDn, Class<T> entryClass, String password) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(bindDn);
        return persistenceEntryManager.authenticate(bindDn, entryClass, password);
    }

    public <T> boolean authenticate(String baseDN, Class<T> entryClass, String userName, String password) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.authenticate(baseDN, entryClass, userName, password);
    }

    public boolean contains(Object entry) {
        Class<?> entryClass = entry.getClass();
        Object dnValue = this.getDNValue(entry, entryClass);
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(dnValue);
        return persistenceEntryManager.contains(entry);
    }

    public <T> boolean contains(String primaryKey, Class<T> entryClass) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(primaryKey);
        return persistenceEntryManager.contains(primaryKey, entryClass);
    }

    public <T> boolean contains(String baseDN, Class<T> entryClass, Filter filter) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.contains(baseDN, entryClass, filter);
    }

    public <T> int countEntries(Object entry) {
        Class<?> entryClass = entry.getClass();
        Object dnValue = this.getDNValue(entry, entryClass);
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(dnValue);
        return persistenceEntryManager.countEntries(entry);
    }

    public <T> int countEntries(String baseDN, Class<T> entryClass, Filter filter) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.countEntries(baseDN, entryClass, filter);
    }

    public <T> int countEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.countEntries(baseDN, entryClass, filter, scope);
    }

    public Date decodeTime(String baseDN, String date) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.decodeTime(baseDN, date);
    }

    public boolean destroy() {
        if (this.persistenceEntryManagers == null) {
            return true;
        }
        boolean result = true;
        for (PersistenceEntryManager persistenceEntryManager : this.persistenceEntryManagers.values()) {
            try {
                result &= persistenceEntryManager.destroy();
            }
            catch (Exception ex) {
                LOG.error("Faild to destroy Persistence Entry Manager", (Throwable)ex);
            }
        }
        return result;
    }

    public String encodeTime(String baseDN, Date date) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.encodeTime(baseDN, date);
    }

    public List<AttributeData> exportEntry(String dn) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(dn);
        return persistenceEntryManager.exportEntry(dn);
    }

    public <T> List<AttributeData> exportEntry(String dn, String objectClass) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(dn);
        return persistenceEntryManager.exportEntry(dn, objectClass);
    }

    public <T> void importEntry(String dn, Class<T> entryClass, List<AttributeData> data) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    public <T> T find(Class<T> entryClass, Object primaryKey) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(primaryKey);
        return (T)persistenceEntryManager.find(entryClass, primaryKey);
    }

    public <T> T find(Object primaryKey, Class<T> entryClass, String[] ldapReturnAttributes) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(primaryKey);
        return (T)persistenceEntryManager.find(primaryKey, entryClass, ldapReturnAttributes);
    }

    public <T> List<T> findEntries(Object entry) {
        Class<?> entryClass = entry.getClass();
        Object dnValue = this.getDNValue(entry, entryClass);
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(dnValue);
        return persistenceEntryManager.findEntries(entry);
    }

    public <T> List<T> findEntries(Object entry, int count) {
        Class<?> entryClass = entry.getClass();
        Object dnValue = this.getDNValue(entry, entryClass);
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(dnValue);
        return persistenceEntryManager.findEntries(entry, count);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.findEntries(baseDN, entryClass, filter);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, int count) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.findEntries(baseDN, entryClass, filter, count);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope, String[] ldapReturnAttributes, BatchOperation<T> batchOperation, int start, int count, int chunkSize) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.findEntries(baseDN, entryClass, filter, scope, ldapReturnAttributes, batchOperation, start, count, chunkSize);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope, String[] ldapReturnAttributes, int start, int count, int chunkSize) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.findEntries(baseDN, entryClass, filter, scope, ldapReturnAttributes, start, count, chunkSize);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, String[] ldapReturnAttributes) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.findEntries(baseDN, entryClass, filter, ldapReturnAttributes);
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, String[] ldapReturnAttributes, int count) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.findEntries(baseDN, entryClass, filter, ldapReturnAttributes, count);
    }

    public <T> PagedResult<T> findPagedEntries(String baseDN, Class<T> entryClass, Filter filter, String[] ldapReturnAttributes, String sortBy, SortOrder sortOrder, int start, int count, int chunkSize) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(baseDN);
        return persistenceEntryManager.findPagedEntries(baseDN, entryClass, filter, ldapReturnAttributes, sortBy, sortOrder, start, count, chunkSize);
    }

    public boolean hasBranchesSupport(String dn) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(dn);
        return persistenceEntryManager.hasBranchesSupport(dn);
    }

    public boolean hasExpirationSupport(String dn) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(dn);
        return persistenceEntryManager.hasExpirationSupport(dn);
    }

    public String getPersistenceType() {
        return HybridEntryManagerFactory.PERSISTENCE_TYPE;
    }

    public String getPersistenceType(String primaryKey) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(primaryKey);
        return persistenceEntryManager.getPersistenceType(primaryKey);
    }

    public PersistenceEntryManager getPersistenceEntryManager(String persistenceType) {
        PersistenceEntryManager persistenceEntryManager = this.persistenceEntryManagers.get(persistenceType);
        if (persistenceEntryManager != null) {
            return persistenceEntryManager;
        }
        if (HybridEntryManagerFactory.PERSISTENCE_TYPE.equals(persistenceType)) {
            return this;
        }
        return null;
    }

    private PersistenceEntryManager getPersistenceEntryManagerByKey(String key) {
        if ("_".equals(key)) {
            return this.defaultPersistenceEntryManager;
        }
        Object[] baseNameParts = key.split("_");
        if (ArrayHelper.isEmpty((Object[])baseNameParts)) {
            throw new KeyConversionException("Failed to determine base key part!");
        }
        PersistenceEntryManager persistenceEntryManager = this.baseNameToEntryManagerMapping.get(baseNameParts[0]);
        if (persistenceEntryManager != null) {
            return persistenceEntryManager;
        }
        return this.defaultPersistenceEntryManager;
    }

    private PersistenceEntryManager getEntryManagerForDn(Object baseDn) {
        if (StringHelper.isEmptyString((Object)baseDn)) {
            throw new MappingException("Entry DN is null");
        }
        return this.getEntryManagerForDn(baseDn.toString());
    }

    private PersistenceEntryManager getEntryManagerForDn(String baseDn) {
        if (StringHelper.isEmpty((String)baseDn)) {
            throw new MappingException("Entry DN is null");
        }
        ParsedKey parsedKey = KEY_CONVERTER.convertToKey(baseDn);
        return this.getPersistenceEntryManagerByKey(parsedKey.getKey());
    }

    public HybridPersistenceOperationService getOperationService() {
        return this.operationService;
    }

    public Void merge(Object entry) {
        Class<?> entryClass = entry.getClass();
        Object dnValue = this.getDNValue(entry, entryClass);
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(dnValue);
        return persistenceEntryManager.merge(entry);
    }

    public void persist(Object entry) {
        Class<?> entryClass = entry.getClass();
        Object dnValue = this.getDNValue(entry, entryClass);
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(dnValue);
        persistenceEntryManager.persist(entry);
    }

    public void remove(Object entry) {
        Class<?> entryClass = entry.getClass();
        Object dnValue = this.getDNValue(entry, entryClass);
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(dnValue);
        persistenceEntryManager.remove(entry);
    }

    public <T> void removeByDn(String primaryKey, String[] objectClasses) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(primaryKey);
        persistenceEntryManager.removeByDn(primaryKey, objectClasses);
    }

    public <T> int remove(String primaryKey, Class<T> entryClass, Filter filter, int count) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(primaryKey);
        return persistenceEntryManager.remove(primaryKey, entryClass, filter, count);
    }

    public void removeDeleteSubscriber(DeleteNotifier subscriber) {
        if (this.persistenceEntryManagers == null) {
            return;
        }
        for (PersistenceEntryManager persistenceEntryManager : this.persistenceEntryManagers.values()) {
            persistenceEntryManager.removeDeleteSubscriber(subscriber);
        }
    }

    public <T> void removeRecursivelyFromDn(String dn, String[] objectClasses) {
        PersistenceEntryManager persistenceEntryManager = this.getEntryManagerForDn(dn);
        persistenceEntryManager.removeRecursivelyFromDn(dn, objectClasses);
    }

    protected void persist(String dn, String[] objectClasses, List<AttributeData> attributes, Integer expiration) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    protected void merge(String dn, String[] objectClasses, List<AttributeDataModification> attributeDataModifications, Integer expiration) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    protected List<AttributeData> find(String dn, String[] objectClasses, Map<String, PropertyAnnotation> propertiesAnnotationsMap, String ... ldapReturnAttributes) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    protected <T> boolean contains(String baseDN, String[] objectClasses, Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, Filter filter, String[] ldapReturnAttributes) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    protected Date decodeTime(String date) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    protected String encodeTime(Date date) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    protected <T> void updateMergeChanges(String baseDn, T entry, boolean isConfigurationUpdate, Class<?> entryClass, Map<String, AttributeData> attributesFromLdapMap, List<AttributeDataModification> attributeDataModifications, boolean forceUpdate) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    protected Object getNativeDateAttributeValue(Date dateValue) {
        throw new UnsupportedOperationException("Method not implemented.");
    }
}

