/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.ldap;

import com.unboundid.util.StaticUtils;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.ldap.LdapSample;
import io.jans.orm.ldap.LoggingHelper;
import io.jans.orm.ldap.impl.LdapEntryManager;
import io.jans.orm.ldap.model.SimpleClient;
import io.jans.orm.ldap.model.SimpleSession;
import io.jans.orm.ldap.model.SimpleTokenLdap;
import io.jans.orm.ldap.persistence.LdapEntryManagerSample;
import io.jans.orm.model.BatchOperation;
import io.jans.orm.model.DefaultBatchOperation;
import io.jans.orm.model.ProcessBatchOperation;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.base.CustomAttribute;
import io.jans.orm.search.filter.Filter;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;

public final class LdapBatchJobSample {
    private static final Logger LOG;

    private LdapBatchJobSample() {
    }

    public static void main(String[] args) {
        LdapEntryManagerSample ldapEntryManagerSample = new LdapEntryManagerSample();
        final LdapEntryManager ldapEntryManager = ldapEntryManagerSample.createLdapEntryManager();
        ProcessBatchOperation<SimpleTokenLdap> tokenLdapBatchOperation = new ProcessBatchOperation<SimpleTokenLdap>(){
            private int processedCount = 0;

            public void performAction(List<SimpleTokenLdap> objects) {
                for (SimpleTokenLdap simpleTokenLdap : objects) {
                    try {
                        CustomAttribute customAttribute = LdapBatchJobSample.getUpdatedAttribute(ldapEntryManager, simpleTokenLdap.getDn(), "exp", simpleTokenLdap.getAttribute("exp"));
                        simpleTokenLdap.setCustomAttributes(Arrays.asList(customAttribute));
                        ldapEntryManager.merge((Object)simpleTokenLdap);
                        ++this.processedCount;
                    }
                    catch (EntryPersistenceException ex) {
                        LOG.error((Object)"Failed to update entry", (Throwable)ex);
                    }
                }
                LOG.info((Object)("Total processed: " + this.processedCount));
            }
        };
        Filter filter1 = Filter.createPresenceFilter((String)"exp");
        ldapEntryManager.findEntries("o=jans", SimpleTokenLdap.class, filter1, SearchScope.SUB, new String[]{"exp"}, (BatchOperation)tokenLdapBatchOperation, 0, 0, 100);
        ProcessBatchOperation<SimpleSession> sessionBatchOperation = new ProcessBatchOperation<SimpleSession>(){
            private int processedCount = 0;

            public void performAction(List<SimpleSession> objects) {
                for (SimpleSession simpleSession : objects) {
                    try {
                        CustomAttribute customAttribute = LdapBatchJobSample.getUpdatedAttribute(ldapEntryManager, simpleSession.getDn(), "jansLastAccessTime", simpleSession.getAttribute("jansLastAccessTime"));
                        simpleSession.setCustomAttributes(Arrays.asList(customAttribute));
                        ldapEntryManager.merge((Object)simpleSession);
                        ++this.processedCount;
                    }
                    catch (EntryPersistenceException ex) {
                        LOG.error((Object)"Failed to update entry", (Throwable)ex);
                    }
                }
                LOG.info((Object)("Total processed: " + this.processedCount));
            }
        };
        Filter filter2 = Filter.createPresenceFilter((String)"jansLastAccessTime");
        ldapEntryManager.findEntries("o=jans", SimpleSession.class, filter2, SearchScope.SUB, new String[]{"jansLastAccessTime"}, (BatchOperation)sessionBatchOperation, 0, 0, 100);
        ProcessBatchOperation<SimpleClient> clientBatchOperation = new ProcessBatchOperation<SimpleClient>(){
            private int processedCount = 0;

            public void performAction(List<SimpleClient> objects) {
                for (SimpleClient simpleClient : objects) {
                    ++this.processedCount;
                }
                LOG.info((Object)("Total processed: " + this.processedCount));
            }
        };
        Filter filter3 = Filter.createPresenceFilter((String)"exp");
        List result3 = ldapEntryManager.findEntries("o=jans", SimpleClient.class, filter3, SearchScope.SUB, new String[]{"exp"}, (BatchOperation)clientBatchOperation, 0, 0, 1000);
        LOG.info((Object)("Result count (without collecting results): " + result3.size()));
        DefaultBatchOperation<SimpleClient> clientBatchOperation2 = new DefaultBatchOperation<SimpleClient>(){
            private int processedCount = 0;

            public void performAction(List<SimpleClient> objects) {
                for (SimpleClient simpleClient : objects) {
                    ++this.processedCount;
                }
                LOG.info((Object)("Total processed: " + this.processedCount));
            }
        };
        Filter filter4 = Filter.createPresenceFilter((String)"exp");
        List result4 = ldapEntryManager.findEntries("o=jans", SimpleClient.class, filter4, SearchScope.SUB, new String[]{"exp"}, (BatchOperation)clientBatchOperation2, 0, 0, 1000);
        LOG.info((Object)("Result count (with collecting results): " + result4.size()));
    }

    private static CustomAttribute getUpdatedAttribute(LdapEntryManager ldapEntryManager, String baseDn, String attributeName, String attributeValue) {
        try {
            Calendar calendar = Calendar.getInstance();
            Date jansLastAccessTimeDate = StaticUtils.decodeGeneralizedTime((String)attributeValue);
            calendar.setTime(jansLastAccessTimeDate);
            calendar.add(13, -1);
            CustomAttribute customAttribute = new CustomAttribute();
            customAttribute.setName(attributeName);
            customAttribute.setValue(ldapEntryManager.encodeTime(baseDn, calendar.getTime()));
            return customAttribute;
        }
        catch (ParseException e) {
            LOG.error((Object)"Can't parse attribute", (Throwable)e);
            return null;
        }
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        LOG = Logger.getLogger(LdapSample.class);
    }
}

