/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.ldap;

import io.jans.orm.ldap.impl.LdapEntryManager;
import io.jans.orm.ldap.model.SimpleAttribute;
import io.jans.orm.ldap.model.SimpleGrant;
import io.jans.orm.ldap.model.SimpleSession;
import io.jans.orm.ldap.model.SimpleUser;
import io.jans.orm.ldap.persistence.LdapEntryManagerSample;
import io.jans.orm.model.PagedResult;
import io.jans.orm.model.SearchScope;
import io.jans.orm.model.SortOrder;
import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.orm.search.filter.Filter;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapSample {
    private static final Logger LOG = LoggerFactory.getLogger(LdapSample.class);

    private LdapSample() {
    }

    public static void main(String[] args) {
        LdapEntryManagerSample ldapEntryManagerSample = new LdapEntryManagerSample();
        LdapEntryManager ldapEntryManager = ldapEntryManagerSample.createLdapEntryManager();
        SimpleUser newUser = new SimpleUser();
        newUser.setDn(String.format("inum=%s,ou=people,o=jans", System.currentTimeMillis()));
        newUser.setUserId("sample_user_" + System.currentTimeMillis());
        newUser.setUserPassword("pwd");
        newUser.getCustomAttributes().add(new CustomObjectAttribute("address", Arrays.asList("London", "Texas", "Kiev")));
        newUser.getCustomAttributes().add(new CustomObjectAttribute("transientId", (Object)"transientId"));
        ldapEntryManager.persist((Object)newUser);
        SimpleUser dummyUser = (SimpleUser)ldapEntryManager.find(SimpleUser.class, (Object)newUser.getDn());
        LOG.info("Dummy User '{}'", (Object)dummyUser);
        List users = ldapEntryManager.findEntries("o=jans", SimpleUser.class, null);
        for (SimpleUser user : users) {
            LOG.debug("User with uid: " + user.getUserId());
        }
        if (users.size() > 0) {
            SimpleUser user = (SimpleUser)users.get(0);
            user.getCustomAttributes().add(new CustomObjectAttribute("streetAddress", (Object)("Somewhere: " + System.currentTimeMillis())));
            ldapEntryManager.merge((Object)user);
        }
        Filter filter = Filter.createEqualityFilter((String)"status", (Object)"active");
        List attributes = ldapEntryManager.findEntries("o=jans", SimpleAttribute.class, filter, SearchScope.SUB, null, null, 10, 0, 0);
        for (SimpleAttribute attribute : attributes) {
            LOG.debug("Attribute with displayName: " + attribute.getCustomAttributes().get(1));
        }
        List sessions = ldapEntryManager.findEntries("o=jans", SimpleSession.class, filter, SearchScope.SUB, null, null, 10, 0, 0);
        LOG.debug("Found sessions: " + sessions.size());
        List grants = ldapEntryManager.findEntries("o=jans", SimpleGrant.class, null, SearchScope.SUB, new String[]{"grtId"}, null, 10, 0, 0);
        LOG.debug("Found grants: " + grants.size());
        try {
            PagedResult vlvResponse = ldapEntryManager.findPagedEntries("o=jans", SimpleUser.class, null, new String[]{"uid", "displayName", "status"}, "displayName", SortOrder.ASCENDING, 10, 100000, 1000);
            LOG.debug("Found persons: " + vlvResponse.getTotalEntriesCount());
            System.out.println(vlvResponse.getEntries().size());
        }
        catch (Exception ex) {
            LOG.error("Failed to search", (Throwable)ex);
        }
    }
}

