/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.ldap;

import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.ldap.LoggingHelper;
import io.jans.orm.ldap.impl.LdapEntryManager;
import io.jans.orm.ldap.model.SimpleSessionState;
import io.jans.orm.ldap.persistence.LdapEntryManagerSample;
import java.util.Date;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;

public final class LdapUpateMissingEntrySample {
    private static final Logger LOG;

    private LdapUpateMissingEntrySample() {
    }

    public static void main(String[] args) {
        LdapEntryManagerSample sqlSampleEntryManager = new LdapEntryManagerSample();
        LdapEntryManager sqlEntryManager = sqlSampleEntryManager.createLdapEntryManager();
        String sessionId = UUID.randomUUID().toString();
        String sessionDn = "uniqueIdentifier=" + sessionId + ",ou=session,o=jans";
        SimpleSessionState simpleSessionState = new SimpleSessionState();
        simpleSessionState.setDn(sessionDn);
        simpleSessionState.setId(sessionId);
        simpleSessionState.setLastUsedAt(new Date());
        try {
            sqlEntryManager.merge((Object)simpleSessionState);
            System.out.println("Updated");
        }
        catch (EntryPersistenceException ex) {
            LOG.info((Object)String.format("Failed to update, root case exception: %s", ex.getCause().getClass()), (Throwable)ex);
        }
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        LOG = Logger.getLogger(LdapUpateMissingEntrySample.class);
    }
}

