/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.ldap;

import io.jans.orm.ldap.LoggingHelper;
import io.jans.orm.ldap.impl.LdapEntryManager;
import io.jans.orm.ldap.model.SimpleSessionState;
import io.jans.orm.ldap.persistence.LdapEntryManagerSample;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;

public final class LdapSimpleSessionSample {
    private static final Logger LOG;

    private LdapSimpleSessionSample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        LdapEntryManagerSample ldapEntryManagerSample = new LdapEntryManagerSample();
        final LdapEntryManager ldapEntryManager = ldapEntryManagerSample.createLdapEntryManager();
        try {
            String sessionId = "xyzcyzxy-a41a-45ad-8a83-61485dbad561";
            final String sessionDn = "uniqueIdentifier=" + sessionId + ",ou=session,o=jans";
            String userDn = "inum=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163!0000!A8F2.DE1E.D7FB,ou=people,o=jans";
            SimpleSessionState simpleSessionState = new SimpleSessionState();
            simpleSessionState.setDn(sessionDn);
            simpleSessionState.setId(sessionId);
            simpleSessionState.setLastUsedAt(new Date());
            ldapEntryManager.persist((Object)simpleSessionState);
            System.out.println("Persisted");
            int threadCount = 500;
            ExecutorService executorService = Executors.newFixedThreadPool(threadCount, LdapSimpleSessionSample.daemonThreadFactory());
            int i = 0;
            while (i < threadCount) {
                final int count = i++;
                executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        SimpleSessionState simpleSessionStateFromLdap = (SimpleSessionState)ldapEntryManager.find(SimpleSessionState.class, (Object)sessionDn);
                        String beforeUserDn = simpleSessionStateFromLdap.getUserDn();
                        String randomUserDn = count % 2 == 0 ? "inum=@!E8F2.853B.1E7B.ACE2!0001!39A4.C163!0000!A8F2.DE1E.D7FB,ou=people,o=jans" : "";
                        try {
                            simpleSessionStateFromLdap.setUserDn(randomUserDn);
                            simpleSessionStateFromLdap.setLastUsedAt(new Date());
                            ldapEntryManager.merge((Object)simpleSessionStateFromLdap);
                            System.out.println("Merged thread: " + count + ", userDn: " + randomUserDn + ", before userDn: " + beforeUserDn);
                        }
                        catch (Throwable e) {
                            System.out.println("ERROR !!!, thread: " + count + ", userDn: " + randomUserDn + ", before userDn: " + beforeUserDn + ", error:" + e.getMessage());
                        }
                    }
                });
            }
            Thread.sleep(5000L);
        }
        finally {
            ldapEntryManager.getOperationService().getConnectionPool().close();
        }
    }

    public static ThreadFactory daemonThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        LOG = Logger.getLogger(LdapSimpleSessionSample.class);
    }
}

