/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.ldap;

import io.jans.orm.ldap.LoggingHelper;
import io.jans.orm.ldap.impl.LdapEntryManager;
import io.jans.orm.ldap.model.SimpleUser;
import io.jans.orm.ldap.persistence.LdapEntryManagerSample;
import io.jans.orm.search.filter.Filter;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;

public final class LdapUserFieldRemove {
    private static final Logger LOG;

    private LdapUserFieldRemove() {
    }

    public static void main(String[] args) {
        Filter filter;
        LdapEntryManagerSample ldapSampleEntryManager = new LdapEntryManagerSample();
        LdapEntryManager ldapEntryManager = ldapSampleEntryManager.createLdapEntryManager();
        List users = ldapEntryManager.findEntries("o=jans", SimpleUser.class, filter = Filter.createEqualityFilter((String)"uid", (Object)"admin"));
        if (users.size() == 0) {
            LOG.error((Object)("Failed to find user by filter: " + filter));
            return;
        }
        LOG.debug((Object)("Find user by filter: " + filter));
        SimpleUser user = (SimpleUser)users.get(0);
        user.setAttribute("jansEnrollmentCode", "test-enrollment-code", false);
        ldapEntryManager.merge((Object)user);
        SimpleUser userWithEnrollment = (SimpleUser)ldapEntryManager.find(SimpleUser.class, (Object)user.getDn());
        if (users.size() == 0) {
            LOG.error((Object)("Failed to find user by DN: " + user.getDn()));
            return;
        }
        userWithEnrollment.setAttribute("jansEnrollmentCode", "", false);
        ldapEntryManager.merge((Object)userWithEnrollment);
        SimpleUser userWithoutEnrollment = (SimpleUser)ldapEntryManager.find(SimpleUser.class, (Object)user.getDn());
        if (users.size() == 0) {
            LOG.error((Object)("Failed to find user by DN: " + user.getDn()));
            return;
        }
        Object enrollmentCode = userWithoutEnrollment.getAttribute("jansEnrollmentCode");
        LOG.debug((Object)("jansEnrollmentCode: " + enrollmentCode));
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        LoggingHelper.configureConsoleAppender();
        LOG = Logger.getLogger(LdapUserFieldRemove.class);
    }
}

