/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.ldap.impl;

import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import io.jans.orm.util.StringHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdifDataUtility {
    private static final Logger LOG = LoggerFactory.getLogger(LdifDataUtility.class);

    private LdifDataUtility() {
    }

    public static LdifDataUtility instance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode importLdifFile(LDAPConnection connection, String ldifFileName) {
        LDIFReader ldifReader = this.createLdifReader(ldifFileName);
        if (ldifReader == null) {
            return ResultCode.LOCAL_ERROR;
        }
        try {
            ResultCode resultCode = this.importLdifFile(connection, ldifReader);
            return resultCode;
        }
        finally {
            this.disposeLdifReader(ldifReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode importLdifFileContent(LDAPConnection connection, String ldifFileContent) {
        ResultCode resultCode;
        BufferedReader is = null;
        LDIFReader ldifReader = null;
        try {
            is = new BufferedReader(new StringReader(ldifFileContent));
            ldifReader = new LDIFReader(is);
            resultCode = this.importLdifFile(connection, ldifReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            if (ldifReader != null) {
                this.disposeLdifReader(ldifReader);
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        if (ldifReader != null) {
            this.disposeLdifReader(ldifReader);
        }
        return resultCode;
    }

    public ResultCode importLdifFile(LDAPConnection connection, LDIFReader ldifReader) {
        ResultCode resultCode = ResultCode.SUCCESS;
        while (true) {
            LDIFChangeRecord ldifRecord = null;
            try {
                ldifRecord = ldifReader.readChangeRecord(true);
            }
            catch (LDIFException le) {
                LOG.error("Malformed ldif record", (Throwable)le);
                if (!le.mayContinueReading()) {
                    resultCode = ResultCode.DECODING_ERROR;
                    break;
                }
            }
            catch (IOException ioe) {
                LOG.error("I/O error encountered while reading a change record", (Throwable)ioe);
                resultCode = ResultCode.LOCAL_ERROR;
                break;
            }
            if (ldifRecord == null) break;
            try {
                ldifRecord.processChange((LDAPInterface)connection);
            }
            catch (LDAPException le) {
                if (ResultCode.ENTRY_ALREADY_EXISTS.equals((Object)le.getResultCode()) || ldifRecord.getChangeType().equals((Object)ChangeType.DELETE)) continue;
                LOG.error("Failed to inserting ldif record", (Throwable)le);
            }
        }
        return resultCode;
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkIfSerrverHasEntryFromLDIFFile(LDAPConnection connection, String ldifFileName) {
        ldifReader = this.createLdifReader(ldifFileName);
        if (ldifReader == null) {
            return true;
        }
        while (true) {
            entry = null;
            try {
                entry = ldifReader.readEntry();
            }
            catch (LDIFException le) {
                LdifDataUtility.LOG.error("Malformed ldif record", (Throwable)le);
                if (!le.mayContinueReading()) {
                    return true;
                }
            }
            catch (IOException ioe) {
                LdifDataUtility.LOG.error("I/O error encountered while reading a change record", (Throwable)ioe);
                return true;
            }
            if (entry == null) break;
            try {
                sr = connection.search(entry.getDN(), SearchScope.BASE, "objectClass=*", new String[0]);
                if (sr == null || sr.getEntryCount() <= 0) continue;
                return true;
            }
            catch (LDAPException le) {
                if (le.getResultCode() != ResultCode.NO_SUCH_OBJECT) ** break;
                continue;
                LdifDataUtility.LOG.error("Failed to search ldif record", (Throwable)le);
                return true;
            }
            break;
        }
        this.disposeLdifReader(ldifReader);
        return false;
    }

    public ResultCode deleteEntryWithAllSubs(LDAPConnection connection, String baseDN) {
        ResultCode resultCode = ResultCode.SUCCESS;
        SearchResult searchResult = null;
        try {
            searchResult = connection.search(baseDN, SearchScope.SUB, "objectClass=*", new String[0]);
            if (searchResult == null || searchResult.getEntryCount() == 0) {
                return ResultCode.LOCAL_ERROR;
            }
        }
        catch (LDAPSearchException le) {
            LOG.error("Failed to search subordinate entries", (Throwable)le);
            return ResultCode.LOCAL_ERROR;
        }
        LinkedList<String> dns = new LinkedList<String>();
        for (SearchResultEntry entry : searchResult.getSearchEntries()) {
            dns.add(entry.getDN());
        }
        ListIterator listIterator = dns.listIterator(dns.size());
        while (listIterator.hasPrevious()) {
            try {
                connection.delete((String)listIterator.previous());
            }
            catch (LDAPException le) {
                LOG.error("Failed to delete entry", (Throwable)le);
                resultCode = ResultCode.LOCAL_ERROR;
                break;
            }
        }
        return resultCode;
    }

    private LDIFReader createLdifReader(String ldifFileNamePath) {
        LDIFReader ldifReader;
        File ldifFile = new File(ldifFileNamePath);
        try {
            if (!ldifFile.exists()) {
                return null;
            }
            ldifReader = new LDIFReader(ldifFile);
        }
        catch (IOException ex) {
            LOG.error("I/O error creating the LDIF reader", (Throwable)ex);
            return null;
        }
        return ldifReader;
    }

    private void disposeLdifReader(LDIFReader ldifReader) {
        if (ldifReader != null) {
            try {
                ldifReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ResultCode validateLDIF(LDIFReader ldifReader, String dn) {
        LDIFChangeRecord ldifRecord;
        String baseDn = dn.toLowerCase();
        ResultCode resultCode = ResultCode.SUCCESS;
        do {
            ldifRecord = null;
            try {
                ldifRecord = ldifReader.readChangeRecord(true);
                if (ldifRecord == null || !StringHelper.isNotEmpty((String)baseDn) || ldifRecord.getDN().toLowerCase().endsWith(baseDn)) continue;
                resultCode = ResultCode.NOT_SUPPORTED;
            }
            catch (LDIFException le) {
                LOG.info("Malformed ldif record " + ldifRecord);
                LOG.error("Malformed ldif record", (Throwable)le);
                resultCode = ResultCode.DECODING_ERROR;
            }
            catch (IOException ioe) {
                LOG.error("I/O error encountered while reading a change record", (Throwable)ioe);
                resultCode = ResultCode.LOCAL_ERROR;
            }
            break;
        } while (ldifRecord != null);
        return resultCode;
    }

    public List<SearchResultEntry> getAttributeResultEntryLDIF(LDAPConnection connection, List<String> patterns, String baseDN) {
        ArrayList<SearchResultEntry> searchResultEntryList = new ArrayList<SearchResultEntry>();
        try {
            for (String pattern : patterns) {
                String[] targetArray = new String[]{pattern};
                Filter inumFilter = Filter.createSubstringFilter((String)"inum", null, (String[])targetArray, null);
                Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{inumFilter});
                SearchResultEntry sr = connection.searchForEntry(baseDN, SearchScope.SUB, searchFilter, null);
                searchResultEntryList.add(sr);
            }
            return searchResultEntryList;
        }
        catch (LDAPException le) {
            if (le.getResultCode() != ResultCode.NO_SUCH_OBJECT) {
                LOG.error("Failed to search ldif record", (Throwable)le);
                return null;
            }
            return null;
        }
    }

    private static class Holder {
        private static LdifDataUtility INSTANCE = new LdifDataUtility();

        private Holder() {
        }
    }
}

