/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.model.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class LocalizedString
implements Serializable {
    private static final long serialVersionUID = -7651487701235873969L;
    private Map<String, String> values = new HashMap<String, String>();
    public static final String EMPTY_LANG_TAG = "";
    public static final String LANG_SEPARATOR = ";";
    public static final String LANG_CLAIM_SEPARATOR = "#";
    public static final String LANG_PREFIX = "lang";
    public static final String LANG_JOINER = "-";
    public static final String LOCALIZED = "Localized";

    public void setValue(String value) {
        this.values.put(EMPTY_LANG_TAG, value);
    }

    public void setValue(String value, Locale locale) {
        this.values.put(LocalizedString.getLanguageTag(locale), value);
    }

    @JsonIgnore
    public String getValue() {
        return this.getValue(EMPTY_LANG_TAG);
    }

    @JsonIgnore
    public String getValue(String languageTag) {
        return this.values.getOrDefault(languageTag, null);
    }

    @JsonIgnore
    public String getValue(Locale locale) {
        return this.getValue(LocalizedString.getLanguageTag(locale));
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public void setValues(Map<String, String> values) {
        this.values = values;
    }

    public int size() {
        return this.values.size();
    }

    @JsonIgnore
    public Set<String> getLanguageTags() {
        return this.values != null ? this.values.keySet() : Collections.emptySet();
    }

    public String addLdapLanguageTag(String ldapAttributeName, String languageTag) {
        return ldapAttributeName + (String)(StringUtils.isNotBlank((CharSequence)languageTag) ? ";lang-" + languageTag : EMPTY_LANG_TAG);
    }

    public String removeLdapLanguageTag(String value, String ldapAttributeName) {
        return value.replaceAll("(?i)" + ldapAttributeName, EMPTY_LANG_TAG).replace(";lang-", EMPTY_LANG_TAG);
    }

    @JsonIgnore
    public static String getLanguageTag(Locale locale) {
        ArrayList<String> keyParts = new ArrayList<String>();
        keyParts.add(locale.getLanguage());
        keyParts.add(locale.getScript());
        keyParts.add(locale.getCountry());
        return keyParts.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(LANG_JOINER));
    }

    public Map addToMap(Map map, String key) {
        if (this.values.isEmpty()) {
            return map;
        }
        for (String languageTag : this.getLanguageTags()) {
            if (StringUtils.isBlank((CharSequence)languageTag)) {
                map.put(key, this.getValue());
                continue;
            }
            map.put(key + LANG_CLAIM_SEPARATOR + languageTag, this.getValue(languageTag));
        }
        return map;
    }

    public void addToJSON(JSONObject jsonObj, String claimName) {
        this.getLanguageTags().forEach(languageTag -> {
            StringBuilder keyStringBuilder = new StringBuilder().append(claimName).append((String)(StringUtils.isNotBlank((CharSequence)languageTag) ? LANG_CLAIM_SEPARATOR + languageTag : EMPTY_LANG_TAG));
            jsonObj.put(keyStringBuilder.toString(), (Object)this.getValue((String)languageTag));
        });
    }

    public void loadFromJson(JSONObject jsonObject, String ldapAttributeName) {
        if (jsonObject == null) {
            return;
        }
        jsonObject.keySet().forEach(localeStr -> {
            String languageTag = this.removeLdapLanguageTag((String)localeStr, ldapAttributeName);
            this.setValue(jsonObject.getString(localeStr), Locale.forLanguageTag(languageTag));
        });
    }

    public String toString() {
        return this.values.toString();
    }

    public static void fromJson(JSONObject requestObject, String paramName, BiFunction<String, Locale, Void> function) {
        List<String> keys = requestObject.keySet().stream().filter(k -> k.startsWith(paramName)).collect(Collectors.toList());
        keys.forEach(key -> {
            key = key.replace(paramName, EMPTY_LANG_TAG);
            String[] keyParts = key.split(LANG_CLAIM_SEPARATOR);
            String languageTag = keyParts[keyParts.length - 1];
            function.apply(requestObject.getString(paramName + key), Locale.forLanguageTag(languageTag));
        });
    }
}

