/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.model.base;

import io.jans.orm.model.base.LocalizedString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class LocalizedStringTest {
    final String[] LANGUAGE_TAGS = new String[]{"", "es", "es-BO", "en-GB", "en-CA", "en-NZ", "fr", "fr-FR", "fr-CA", "ja-Jpan-JP", "ja-Kana-JP", "ja-Hani-JP"};
    final String[] LOCALIZED_VALUES = new String[]{"Client name", "Nombre del cliente", "Nombre del cliente", "Client name", "Client name", "Client name", "Nom du client", "Nom du client", "Nom du client", "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u540d", "\u30ab\u30ca\u59d3\u203b", "\u6f22\u5b57\u59d3\u203b"};
    final String[] CLAIM_NAMES = new String[]{"client_name", "client_name#es", "client_name#es-BO", "client_name#en-GB", "client_name#en-CA", "client_name#en-NZ", "client_name#fr", "client_name#fr-FR", "client_name#fr-CA", "client_name#ja-Jpan-JP", "client_name#ja-Kana-JP", "client_name#ja-Hani-JP"};
    final String REQUEST_JSON = "{\n  \"redirect_uris\" : [ \"https://gluu/jans-auth-rp/home.htm\", \"https://client.example.com/cb\", \"https://client.example.com/cb1\", \"https://client.example.com/cb2\" ],\n  \"sector_identifier_uri\" : \"https://gluu/jans-auth/sectoridentifier/a55ede29-8f5a-461d-b06e-76caee8d40b5\",\n  \"response_types\" : [ \"code\", \"token\", \"id_token\" ],\n  \"client_uri\" : \"https://client-home-page/index.htm\",\n  \"application_type\" : \"web\",\n  \"scope\" : \"openid profile address email phone user_name clientinfo\",\n  \"subject_type\" : \"pairwise\",\n  \"client_name\" : \"Client name\",\n  \"client_name#es\" : \"Nombre del cliente\",\n  \"client_name#es-BO\" : \"Nombre del cliente\",\n  \"client_name#en-GB\" : \"Client name\",\n  \"client_name#en-CA\" : \"Client name\",\n  \"client_name#en-NZ\" : \"Client name\",\n  \"client_name#fr\" : \"Nom du client\",\n  \"client_name#fr-FR\" : \"Nom du client\",\n  \"client_name#fr-CA\" : \"Nom du client\",\n  \"client_name#ja-Jpan-JP\" : \"\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u540d\",\n  \"client_name#ja-Kana-JP\" : \"\u30ab\u30ca\u59d3\u203b\",\n  \"client_name#ja-Hani-JP\" : \"\u6f22\u5b57\u59d3\u203b\"\n}";
    LocalizedString localizedString;

    @BeforeClass
    public void setUp() {
        this.localizedString = new LocalizedString();
    }

    @Test
    public void testSetValue() {
        this.localizedString.setValue("Client name");
        this.localizedString.setValue("Nombre del cliente", new Locale("es"));
        this.localizedString.setValue("Nombre del cliente", new Locale("es", "BO"));
        this.localizedString.setValue("Client name", Locale.UK);
        this.localizedString.setValue("Client name", Locale.CANADA);
        this.localizedString.setValue("Client name", Locale.forLanguageTag("en-NZ"));
        this.localizedString.setValue("Nom du client", Locale.FRENCH);
        this.localizedString.setValue("Nom du client", Locale.CANADA_FRENCH);
        this.localizedString.setValue("Nom du client", Locale.FRANCE);
        this.localizedString.setValue("\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u540d", Locale.forLanguageTag("ja-Jpan-JP"));
        this.localizedString.setValue("\u30ab\u30ca\u59d3\u203b", Locale.forLanguageTag("ja-Kana-JP"));
        this.localizedString.setValue("\u6f22\u5b57\u59d3\u203b", Locale.forLanguageTag("ja-Hani-JP"));
        Assert.assertEquals((int)this.localizedString.size(), (int)this.LANGUAGE_TAGS.length);
        Assert.assertTrue((boolean)this.localizedString.getLanguageTags().containsAll(Arrays.asList(this.LANGUAGE_TAGS)));
        for (int i = 0; i < this.LANGUAGE_TAGS.length; ++i) {
            Assert.assertEquals((String)this.localizedString.getValue(this.LANGUAGE_TAGS[i]), (String)this.LOCALIZED_VALUES[i]);
        }
    }

    @Test(dependsOnMethods={"testSetValue"})
    public void testGetValue() {
        Assert.assertEquals((String)this.localizedString.getValue(), (String)"Client name");
    }

    @Test(dependsOnMethods={"testSetValue"})
    public void addToMap() {
        HashMap map = new HashMap();
        this.localizedString.addToMap(map, "client_name");
        Assert.assertEquals((int)map.size(), (int)this.CLAIM_NAMES.length);
        for (int i = 0; i < this.CLAIM_NAMES.length; ++i) {
            Assert.assertTrue((boolean)map.containsKey(this.CLAIM_NAMES[i]));
            Assert.assertEquals(map.get(this.CLAIM_NAMES[i]), (Object)this.LOCALIZED_VALUES[i]);
        }
    }

    @Test(dependsOnMethods={"testSetValue"})
    public void addToJSON() {
        JSONObject jsonObject = new JSONObject();
        this.localizedString.addToJSON(jsonObject, "client_name");
        Assert.assertEquals((int)jsonObject.keySet().size(), (int)this.CLAIM_NAMES.length);
        for (int i = 0; i < this.CLAIM_NAMES.length; ++i) {
            Assert.assertTrue((boolean)jsonObject.keySet().contains(this.CLAIM_NAMES[i]));
            Assert.assertEquals((Object)jsonObject.get(this.CLAIM_NAMES[i]), (Object)this.LOCALIZED_VALUES[i]);
        }
    }

    @Test
    public void fromJson() {
        JSONObject jsonObject = new JSONObject("{\n  \"redirect_uris\" : [ \"https://gluu/jans-auth-rp/home.htm\", \"https://client.example.com/cb\", \"https://client.example.com/cb1\", \"https://client.example.com/cb2\" ],\n  \"sector_identifier_uri\" : \"https://gluu/jans-auth/sectoridentifier/a55ede29-8f5a-461d-b06e-76caee8d40b5\",\n  \"response_types\" : [ \"code\", \"token\", \"id_token\" ],\n  \"client_uri\" : \"https://client-home-page/index.htm\",\n  \"application_type\" : \"web\",\n  \"scope\" : \"openid profile address email phone user_name clientinfo\",\n  \"subject_type\" : \"pairwise\",\n  \"client_name\" : \"Client name\",\n  \"client_name#es\" : \"Nombre del cliente\",\n  \"client_name#es-BO\" : \"Nombre del cliente\",\n  \"client_name#en-GB\" : \"Client name\",\n  \"client_name#en-CA\" : \"Client name\",\n  \"client_name#en-NZ\" : \"Client name\",\n  \"client_name#fr\" : \"Nom du client\",\n  \"client_name#fr-FR\" : \"Nom du client\",\n  \"client_name#fr-CA\" : \"Nom du client\",\n  \"client_name#ja-Jpan-JP\" : \"\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u540d\",\n  \"client_name#ja-Kana-JP\" : \"\u30ab\u30ca\u59d3\u203b\",\n  \"client_name#ja-Hani-JP\" : \"\u6f22\u5b57\u59d3\u203b\"\n}");
        LocalizedString myLocalizedString = new LocalizedString();
        LocalizedString.fromJson((JSONObject)jsonObject, (String)"client_name", (value, locale) -> {
            myLocalizedString.setValue(value, locale);
            return null;
        });
        Assert.assertEquals((int)myLocalizedString.size(), (int)this.LANGUAGE_TAGS.length);
        Assert.assertTrue((boolean)myLocalizedString.getLanguageTags().containsAll(Arrays.asList(this.LANGUAGE_TAGS)));
        for (int i = 0; i < this.LANGUAGE_TAGS.length; ++i) {
            Assert.assertEquals((String)myLocalizedString.getValue(this.LANGUAGE_TAGS[i]), (String)this.LOCALIZED_VALUES[i]);
        }
    }
}

