/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.cloud.spanner.OpenTelemetryApiTracer;
import com.google.common.base.Preconditions;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import javax.annotation.Nonnull;

class OpenTelemetryApiTracerFactory
implements ApiTracerFactory {
    @Nonnull
    private final Tracer internalTracer;
    @Nonnull
    private final Attributes spanAttributes;

    OpenTelemetryApiTracerFactory(@Nonnull Tracer internalTracer, @Nonnull Attributes spanAttributes) {
        this.internalTracer = (Tracer)Preconditions.checkNotNull((Object)internalTracer);
        this.spanAttributes = spanAttributes;
    }

    public ApiTracer newTracer(ApiTracer parent, SpanName spanName, ApiTracerFactory.OperationType operationType) {
        Span parentSpan = Span.current();
        if (parent instanceof OpenTelemetryApiTracer) {
            parentSpan = ((OpenTelemetryApiTracer)parent).getSpan();
        }
        Span span = this.internalTracer.spanBuilder(spanName.toString()).setParent(Context.current().with((ImplicitContextKeyed)parentSpan)).setAllAttributes(this.spanAttributes).startSpan();
        return new OpenTelemetryApiTracer(span, operationType);
    }
}

