/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.protobuf.Timestamp;
import java.util.Map;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

class SessionReference {
    private final String name;
    private final DatabaseId databaseId;
    private final Map<SpannerRpc.Option, ?> options;
    private volatile Instant lastUseTime;
    @Nullable
    private final Instant createTime;
    private final boolean isMultiplexed;

    SessionReference(String name, Map<SpannerRpc.Option, ?> options) {
        this.options = options;
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.databaseId = SessionClient.SessionId.of(name).getDatabaseId();
        this.lastUseTime = Instant.now();
        this.createTime = null;
        this.isMultiplexed = false;
    }

    SessionReference(String name, Timestamp createTime, boolean isMultiplexed, Map<SpannerRpc.Option, ?> options) {
        this.options = options;
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.databaseId = SessionClient.SessionId.of(name).getDatabaseId();
        this.lastUseTime = Instant.now();
        this.createTime = this.convert(createTime);
        this.isMultiplexed = isMultiplexed;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    Map<SpannerRpc.Option, ?> getOptions() {
        return this.options;
    }

    Instant getLastUseTime() {
        return this.lastUseTime;
    }

    Instant getCreateTime() {
        return this.createTime;
    }

    boolean getIsMultiplexed() {
        return this.isMultiplexed;
    }

    void markUsed(Instant instant) {
        this.lastUseTime = instant;
    }

    private Instant convert(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return Instant.ofEpochSecond((long)timestamp.getSeconds(), (long)timestamp.getNanos());
    }
}

